Require Import Basic.

From Coq Require Import Equality Relations RelationClasses List Compare.

Import ListNotations.

Module Type BasicTheories (B : Basic).
  Import B.

  Section NatProps.

    Theorem strong_ind : forall P : nat -> Prop,
        (forall m : nat, (forall n : nat, n < m -> P n) -> P m)
        -> forall n : nat, P n.
      intros P IndCase n.
      enough (forall m, m <= n -> P m) by auto.
      induction n ; intros m mLen.
      * inversion mLen. apply IndCase. intros n nLt0. inversion nLt0.
      * apply IndCase. intros m' m'Ltp. apply IHn. unfold lt in m'Ltp.
        assert (S m' <= S n) by (transitivity m ; auto). auto using le_S_n.
    Qed.

    Lemma le_antisym : forall n m, n <= m -> m <= n -> n = m.
      induction n, m ; intros nLem mLen ; [auto | inversion mLen | inversion nLem |].
      apply f_equal. apply le_S_n in nLem, mLen. auto.
    Qed.

    Lemma le_minus : forall n m, n - m <= n.
      induction n, m ; simpl ; auto.
    Qed.

    Lemma le_or_gt : forall n m, {n <= m} + {m < n}.
      intros n m.
      destruct (le_dec n m) as [| LtMN] ; auto.
      destruct (le_decide m n LtMN) ; subst ; auto.
    Qed.

    Lemma lt_minus_lt : forall m0 m1, m0 < m1 -> forall n, m0 < n -> n - m1 < n - m0.
      unfold lt. induction m0, m1 ; intros ltm1 n ltn ; try rewrite -> minus_zero.
      * inversion ltm1.
      * inversion ltn ; subst ; apply le_n_S ; simpl ; auto using le_minus.
      * inversion ltm1.
      * induction n.
        - inversion ltn.
        - apply le_S_n in ltn, ltm1. pose proof (IHm0 m1 ltm1 n ltn).
          simpl. assumption.
    Qed.

  End NatProps.

  Section ListPrefix.
    Context {A : Type}.
    Notation Prefix := (Prefix (A := A)).

    Lemma cons_neq : forall (lst : list A) (a : A), lst <> a :: lst.
      induction lst ; intro.
      * apply nil_cons.
      * intro LstEq. inversion LstEq. apply IHlst with a0. assumption.
    Qed.

    Lemma cons_app : forall (lst0 lst1 : list A) (a0 a1 : A), a0 :: lst0 = lst1 ++ [a1]
        -> (a0 = a1 /\ lst0 = [] /\ lst1 = []) \/ (exists lst0' lst1', lst0 = lst0' ++ [a1] /\ lst1 = a0 :: lst1').
      induction lst0, lst1 ; intros a0' a1' LstEq ; simpl in LstEq ; injection LstEq ; intro LstEq' ; intros ; subst ; auto.
      * apply app_cons_not_nil in LstEq' ; inversion LstEq'.
      * right. apply IHlst0 in LstEq'.
        destruct LstEq' as [(? & ? & ?) | (lst0' & lst1' & ? & ?)]
        ; [do 2 exists [] | exists (a :: lst0') ; exists (a :: lst1')]
        ; subst ; simpl in * ; auto.
    Qed.

    Lemma lst_eq_app_impl_nil : forall (lst0 lst1 : list A), lst0 = lst0 ++ lst1 -> lst1 = [].
      induction lst0 ; simpl ; intros lst1 LstEq ; try injection LstEq ; auto.
    Qed.

    Lemma prefix_antisymm : forall (lst0 lst1 : list A), Prefix lst0 lst1 -> Prefix lst1 lst0 -> lst0 = lst1.
      intros lst0 lst1 Pfx01 ; induction Pfx01 ; intro Pfx10 ; dependent induction Pfx10 ; auto using f_equal.
    Qed.

    Proposition prefix_as_append : forall (lst0 lst1 : list A), Prefix lst0 lst1 <-> exists lst0', lst0 ++ lst0' = lst1.
      induction lst0 ; intro lst1 ; split ; intro Pfx ; simpl ; eauto.
      * inversion Pfx as [| ? ? ? Pfx'] ; subst. apply IHlst0 in Pfx'.
        destruct Pfx' as [lst' Pfx']. subst. eauto.
      * destruct Pfx as [lst1' Lst0Val]. simpl in Lst0Val. inversion Lst0Val.
        apply Prefix_some. apply IHlst0. eauto.
    Qed.

    Lemma prefix_length : forall (lst0 lst1 : list A), Prefix lst0 lst1 -> length lst0 <= length lst1.
      intros lst0 lst1 Pfx. induction Pfx ; simpl ; auto using le_0_n, le_n_S.
    Qed.

    Lemma prefix_eq_len : forall (lst0 lst1 : list A), Prefix lst0 lst1 -> length lst0 = length lst1 -> lst0 = lst1.
      intros lst0 lst1 Pfx LenEq. induction Pfx ; simpl in *.
      * symmetry in LenEq. apply length_zero_iff_nil in LenEq. auto.
      * inversion LenEq. apply f_equal. auto.
    Qed.

    Lemma eq_or_prefix : forall lst0 lst1 (a : A), Prefix lst0 (lst1 ++ [a]) -> lst0 = lst1 ++ [a] \/ Prefix lst0 lst1.
      intros lst0 lst1 a Pfx. dependent induction Pfx ; auto.
      pose proof (cons_app lst2 lst1 a0 a x) as [(? & ? & ?) | (lst0' & lst1' & ? & ?)] ; subst ; simpl in *.
      * inversion Pfx ; subst ; simpl ; auto.
      * injection x ; intros.
        assert (lst0 = lst1' ++ [a] \/ Prefix lst0 lst1') as [|] by auto ; subst ; auto using Prefix_some.
    Qed.

    Lemma prefix_of_append : forall (lst0 lst1 lst2 : list A), Prefix lst0 (lst1 ++ lst2)
        -> PropPrefix lst0 lst1 \/ (exists lst', lst0 = lst1 ++ lst' /\ Prefix lst' lst2).
      induction lst0, lst1 ; intros lst2 Pfx ; simpl in * ; unfold PropPrefix ; eauto using nil_cons.
      inversion Pfx as [| ? ? ? Pfx'] ; subst.
      apply IHlst0 in Pfx' ; destruct Pfx' as [[? ?] | (lst' & ? & ?)] ; subst
      ; [left ; split ; [| intro ConsNEq ; injection ConsNEq] | right ; exists lst'] ; auto.
    Qed.

    Lemma prop_prefix_length : forall (lst0 lst1 : list A), PropPrefix lst0 lst1 -> length lst0 < length lst1.
      unfold lt. intros lst0 lst1 [Pfx LstNeq]. induction Pfx ; simpl.
      * destruct lst ; [contradict LstNeq | simpl] ; auto using le_0_n, le_n_S.
      * apply le_n_S. apply IHPfx. intro. subst. contradict LstNeq. reflexivity.
    Qed.

    Lemma prefix_in : forall lst0 (a : A) lst0' lst1, Prefix (lst0 ++ a :: lst0') lst1 -> In a lst1.
      induction lst0 as [| a' lst0] ; intros a lst0' lst1 Pfx
      ; simpl in Pfx ; inversion Pfx ; subst ; unfold In
      ; [| right ; apply IHlst0 with lst0']
      ; auto.
    Qed.

    Lemma prefix_tail_eq : forall lst0 lst1 (a : A), Prefix (lst0 ++ [a]) (lst1 ++ [a]) -> ~ In a lst1 -> lst0 = lst1.
      induction lst0 ; destruct lst1 ; intros a' Pfx NotIn ; simpl in * ; auto
      ; inversion Pfx as [| ? ? ? Pfx'] ; subst.
      * contradict NotIn. auto.
      * inversion Pfx'.
        lazymatch goal with
        | [H : [] = _ ++ [_] |- _] => apply app_cons_not_nil in H ; inversion H
        end.
      * apply f_equal. eauto.
    Qed.


  End ListPrefix.

End BasicTheories.