Require Import Basic.
Require Import ImpDefs.

From Coq Require Import RelationClasses List Basics Equality Relations Ensembles.

Import ListNotations.

Module Type TraceDefs (B : Basic) (ID : ImpDefs).
  Import B ID.
  Import ImpNotations.

  Open Scope imp_scope.

  Section Definitions.

    CoInductive EvtStream :=
      | ConsEvt (a : Event) (st : EvtStream) : EvtStream
      | TermEvtSt : EvtStream.

    Inductive EvtPrefix : list Event -> EvtStream -> Prop :=
      | EvtPrefix_empty : forall st, EvtPrefix [] st
      | EvtPrefix_some : forall a lst st, EvtPrefix lst st -> EvtPrefix (a :: lst) (ConsEvt a st).

    Fixpoint prepend (lst : list Event) (st : EvtStream) : EvtStream :=
      match lst with
        | [] => st
        | a :: rst => ConsEvt a (prepend rst st)
      end.

    Definition Trace : Type := Store * EvtStream.

    Definition t_input : Trace -> Store := fst.

    Definition TracePfx : Type := Store * list Event.

    Inductive le_trace : TracePfx -> Trace -> Prop :=
      | LeTrace_intro : forall s lst st, EvtPrefix lst st -> le_trace (s, lst) (s, st).

    Inductive le_pfx : relation TracePfx :=
      | LePfx_intro : forall lst0 lst1, Prefix lst0 lst1 -> forall s, le_pfx (s, lst0) (s, lst1).

    Definition Property : Type := Ensemble Trace.
    Definition Hyperproperty : Type := Ensemble Property.

    CoInductive Produces : Cmd -> Store -> EvtStream -> Prop :=
      | Produces_step : forall c s a c' s' st, (c, s) -->[a] (c', s')
        -> Produces c' s' st -> Produces c s (ConsEvt a st)
      | Produces_term : forall s, Produces Stop s TermEvtSt.

    Definition behavior (c : Cmd) : Property :=
      (fun t => Produces c (fst t) (snd t)).

  End Definitions.

  #[global] Notation "pfx '<=|' t" := (le_trace pfx t) (at level 80): imp_scope.
  #[global] Notation "pfx0 '<=,' pfx1" := (le_pfx pfx0 pfx1) (at level 80): imp_scope.

  Section BasicProperties.

    Lemma le_pfx_refl : forall pfx : TracePfx, pfx <=, pfx.
      induction pfx. apply LePfx_intro ; reflexivity.
    Qed.

    Lemma le_pfx_trans : forall pfx0 pfx1 pfx2, pfx0 <=, pfx1 -> pfx1 <=, pfx2 -> pfx0 <=, pfx2.
      intros pfx0 pfx1 pfx2 Le01 Le12. dependent induction Le01. dependent induction Le12.
      apply LePfx_intro ; transitivity lst1 ; assumption.
    Qed.

  End BasicProperties.

  #[global] Hint Resolve le_pfx_refl : core.

End TraceDefs.