Require Import Basic.
Require Import ImpDefs.
Require Import Trace.
Require Import SecurityDefs.

From Coq Require Import Equality Ensembles.
Require Coq.Lists.List.

Module Type SimpleTactics (B : Basic ) (ID : ImpDefs) (TD : TraceDefs B ID) (SD : SecurityDefs B ID TD).
  Import ID SD.
  Import ImpNotations.

  Lemma stop_not_wt : forall G pc nt, ~ G;; pc |- Stop -| nt.
    intros G pc nt WT. dependent induction WT. auto.
  Qed.

  Ltac handle_simple_contradict :=
    subst ; lazymatch goal with
      | [ WT : ?G;; ?pc |- Stop -| ?nt |- _ ] => contradiction stop_not_wt with G pc nt
      | [ H : (Stop, _) -->[_] _ |- _] => inversion H
      | [ H : ?c <> Stop, Step : (Skip, _) -->[_] (?c, _) |- _ ] => inversion Step ; contradict H ; auto
      | [ H0 : ?x = Some 0, H1 : ?x = Some (S _) |- _ ] => rewrite -> H0 in H1 ; inversion H1
      | [ LowA : deq_evt _ _ ?a NoEvt, HighA : ~ deq_evt _ ?a NoEvt |- _ ] => contradict HighA ; assumption
      | [ H : ~ deq_evt _ _ NoEvt NoEvt |- _ ] => contradict H ; constructor
      | [ H : deq_evt _ _ StopEvt NoEvt |- _ ] => inversion H
      | [ H : deq_evt _ ?d (AssignEvt _ _ ?l) NoEvt, LowL : In Label ?d ?l |- _ ] => inversion H ; exfalso ; auto
      | [ H : ~ deq_evt _ ?d (AssignEvt _ _ ?l) NoEvt, HighL : ~ In Label ?d ?l |- _ ] => contradict H ; apply DEqHighAssignNoEvt ; assumption
      | [ H : deq_evt _ ?d (PDownEvt ?l) NoEvt, LowL : In Label ?d ?l |- _ ] => inversion H ; exfalso ; auto
      | [ H : ~ deq_evt _ ?d (PDownEvt ?l) NoEvt, HighL : ~ In Label ?d ?l |- _ ] => contradict H ; apply DEqHighPDownNoEvt ; assumption
      | [|- _] => solve [discriminate | exfalso ; auto]
    end.

  Import Coq.Lists.List.

  Ltac invert_tail reverser Hypo :=
    rewrite -> reverser in Hypo ; inversion Hypo
    ; repeat lazymatch goal with
      | [H : _ ++ _ :: _ = nil |- _] => symmetry in H ; apply app_cons_not_nil in H ; inversion H
      | [H : nil = _ ++ _ :: _ |- _] => apply app_cons_not_nil in H ; inversion H
      | [H : _ ++ _ :: nil = _ ++ _ :: nil |- _] => apply app_inj_tail in H ; destruct H ; subst
    end
    ; subst ; rewrite <- reverser in * ; try handle_simple_contradict ; eauto.

End SimpleTactics.