Require Import Basic.
Require Import ImpDefs.
Require Import Trace.

From Coq Require Import Equality List Ensembles Relations RelationClasses.

Class DecideIn {A : Type} (S : Ensemble A) := {
  dec_in : forall a, {In A S a} + {~ In A S a}
}.

Module Type SecurityDefs (B : Basic) (ID : ImpDefs) (TD : TraceDefs B ID).
  Import B ID TD.
  Import ImpNotations.

  Open Scope imp_scope.

  Section DEquivalence.

    Variable G : Varname -> option Label.
    Variable D : Ensemble Label.

    Inductive deq_evt : relation Event :=
      | DEqEqEvt : forall evt, deq_evt evt evt
      | DEqHighAssignNoEvt : forall x n l, G x = Some l -> ~(In Label D l) -> deq_evt (AssignEvt x n) NoEvt
      | DEqNoEvtHighAssign : forall x n l, G x = Some l -> ~(In Label D l) -> deq_evt NoEvt (AssignEvt x n)
      | DEqHighPDownNoEvt : forall l, ~(In Label D l) -> deq_evt (PDownEvt l) NoEvt
      | DEqNoEvtHighPDown : forall l, ~(In Label D l) -> deq_evt NoEvt (PDownEvt l)
      | DEqHighAssignHighAssign : forall x n l x' n' l',
        G x = Some l -> ~(In Label D l) -> G x' = Some l' -> ~(In Label D l') -> deq_evt (AssignEvt x n) (AssignEvt x' n')
      | DEqHighAssignHighPDown : forall x n l l',
        G x = Some l -> ~(In Label D l) -> ~(In Label D l') -> deq_evt (AssignEvt x n) (PDownEvt l')
      | DEqHighPDownHighAssign : forall l x n l',
        ~(In Label D l) -> G x = Some l' -> ~(In Label D l') -> deq_evt (PDownEvt l) (AssignEvt x n)
      | DEqHighPDownHighPDown : forall l l',
        ~(In Label D l) -> ~(In Label D l') -> deq_evt (PDownEvt l) (PDownEvt l').

    Inductive deq_evt_lst : relation (list Event) :=
      | DEqEmpty : deq_evt_lst nil nil
      | DEqSame : forall a lst1 lst2, deq_evt_lst lst1 lst2 -> deq_evt_lst (a :: lst1) (a :: lst2)
      | DEqNoEvtL : forall a lst1 lst2, deq_evt a NoEvt -> deq_evt_lst lst1 lst2 -> deq_evt_lst (a :: lst1) lst2
      | DEqNoEvtR : forall a lst1 lst2, deq_evt a NoEvt -> deq_evt_lst lst1 lst2 -> deq_evt_lst lst1 (a :: lst2).

    Definition deq_store (s1 s2 : Store) : Prop :=
      forall x l, G x = Some l -> In Label D l -> (s1 x = s2 x).

    Inductive deq_pfx : TracePfx -> TracePfx -> Prop :=
      | DEqPfx_intro : forall s0 lst0 s1 lst1,
          deq_store s0 s1 -> deq_evt_lst lst0 lst1 -> deq_pfx (s0, lst0) (s1, lst1).

    #[local] Notation "pfx0 '=[D]' pfx1" := (deq_pfx pfx0 pfx1) (at level 80) : imp_scope.

    Definition dle_pfx (pfx0 pfx1 : TracePfx) : Prop :=
      exists pfx1', pfx1' <=, pfx1 /\ pfx0 =[D] pfx1'.

    #[local] Notation "pfx0 '<=[D]' pfx1" := (dle_pfx pfx0 pfx1) (at level 70) : imp_scope.

    Definition dlt_pfx pfx0 pfx1 := pfx0 <=[D] pfx1 /\ ~(pfx0 =[D] pfx1).

    Definition silent c s : Prop :=
      forall cs' lst, (c, s) ==>*[lst] cs' -> deq_evt_lst lst nil.

  End DEquivalence.

  #[global] Notation "pfx0 '=[' G ',' D ']' pfx1" := (deq_pfx G D pfx0 pfx1) (at level 80) : imp_scope.
  #[global] Notation "pfx0 '<=[' G ',' D ']' pfx1" := (dle_pfx G D pfx0 pfx1) (at level 70) : imp_scope.
  #[global] Notation "pfx0 '<[' G ',' D ']' pfx1" := (dlt_pfx G D pfx0 pfx1) (at level 70) : imp_scope.

  Class LowSet (D : Ensemble Label) `{DecideIn Label D} := {
    down_closed : forall l1 l2, In Label D l1 -> flows_to l2 l1 -> In Label D l2
  }.

  Section Noninterference.

    Variable G : Varname -> option Label.

    Definition PiniD (D : Ensemble Label) : Hyperproperty :=
      fun t_set => forall t0 t1, (In Trace t_set t0) -> (In Trace t_set t1)
        -> deq_store G D (t_input t0) (t_input t1) ->
        forall pfx0 pfx1, pfx0 <=| t0 -> pfx1 <=| t1 -> (pfx0 <=[G, D] pfx1 \/ pfx1 <=[G, D] pfx0).

    Definition progress D pfx t := exists pfx', pfx' <=| t /\ pfx <[G, D] pfx'.

    Definition LfpD (D : Ensemble Label) : Hyperproperty :=
      fun t_set => forall t0 t1, (In Trace t_set t0) -> (In Trace t_set t1)
        -> forall pfx0 pfx1, pfx0 <=| t0 -> pfx1 <=| t1 -> pfx0 <[G, D] pfx1 -> progress D pfx0 t0.

    Definition PsniD (D : Ensemble Label) : Hyperproperty :=
      fun t_set => forall t0 t1, (In Trace t_set t0) -> (In Trace t_set t1)
        -> deq_store G D (t_input t0) (t_input t1) ->
        forall pfx0, pfx0 <=| t0 -> exists pfx1, pfx1 <=| t1 /\ pfx0 =[G, D] pfx1.

    Definition Pini : Hyperproperty := fun t_set => forall D `(LowSet D), In Property (PiniD D) t_set.
    Definition Lfp : Hyperproperty := fun t_set => forall D `(LowSet D), In Property (LfpD D) t_set.
    Definition Psni : Hyperproperty := fun t_set => forall D `(LowSet D), In Property (PsniD D) t_set.

  End Noninterference.

  Class Attacker (P T : Ensemble Label) `{LowSet P} `{LowSet T} := {
    non_compromised_low : forall l, flows_to l (reflect l) -> In Label (Union Label P T) l
  }.

  Section NMIF.

    Variable G : Varname -> option Label.

    Inductive nmif_input_match (P T : Ensemble Label) (t_set : Ensemble Trace) (t00 t01 t10 t11 : Trace) : Prop :=
      | NmifInput_intro : In Trace t_set t00 -> In Trace t_set t01 -> In Trace t_set t10 -> In Trace t_set t11
        -> deq_store G P (t_input t00) (t_input t10) -> deq_store G T (t_input t00) (t_input t01)
        -> deq_store G P (t_input t01) (t_input t11) -> deq_store G T (t_input t10) (t_input t11)
        -> nmif_input_match P T t_set t00 t01 t10 t11.

    Definition PiRdA (P T : Ensemble Label) : Hyperproperty :=
      fun t_set => forall t00 t01 t10 t11, (nmif_input_match P T t_set t00 t01 t10 t11)
        -> forall pfx, pfx <=| t00
        -> (forall pfx0, pfx0 <=| t00 -> pfx =[G, T] pfx0 -> exists pfx1, pfx1 <=| t10 /\ pfx0 =[G, P] pfx1)
        -> (forall pfx0 pfx1, pfx0 <=| t01 -> pfx1 <=| t11 -> pfx =[G, T] pfx0 -> (pfx0 <=[G, P] pfx1 \/ pfx1 <=[G, P] pfx0)).

    Definition RplA (P T : Ensemble Label) : Hyperproperty :=
      fun t_set => forall t00 t01 t10 t11, (nmif_input_match P T t_set t00 t01 t10 t11)
        -> forall pfx, pfx <=| t00
        -> (forall pfx0, pfx0 <=| t00 -> pfx =[G, T] pfx0 -> exists pfx1, pfx1 <=| t10 /\ pfx0 =[G, P] pfx1)
        -> (forall pfx0 pfx1, pfx0 <=| t01 -> pfx1 <=| t11 -> pfx =[G, T] pfx0 -> pfx1 <[G, P] pfx0 -> progress G P pfx1 t11).

    Definition PsRdA (P T : Ensemble Label) : Hyperproperty :=
      fun t_set => forall t00 t01 t10 t11, (nmif_input_match P T t_set t00 t01 t10 t11)
        -> forall pfx, pfx <=| t00
        -> (forall pfx0, pfx0 <=| t00 -> pfx =[G, T] pfx0 -> exists pfx1, pfx1 <=| t10 /\ pfx0 =[G, P] pfx1)
        -> (forall pfx0, pfx0 <=| t01 -> pfx =[G, T] pfx0 -> exists pfx1, pfx1 <=| t11 /\ pfx0 =[G, P] pfx1).

    Definition PiTeA (P T : Ensemble Label) : Hyperproperty :=
      fun t_set => forall t00 t01 t10 t11, (nmif_input_match P T t_set t00 t01 t10 t11)
        -> forall pfx, pfx <=| t00
        -> (forall pfx0, pfx0 <=| t00 -> pfx =[G, P] pfx0 -> exists pfx1, pfx1 <=| t01 /\ pfx0 =[G, T] pfx1)
        -> (forall pfx0 pfx1, pfx0 <=| t10 -> pfx1 <=| t11 -> pfx =[G, P] pfx0 -> (pfx0 <=[G, T] pfx1 \/ pfx1 <=[G, T] pfx0)).

    Definition TpcA (P T : Ensemble Label) : Hyperproperty :=
      fun t_set => forall t00 t01 t10 t11, (nmif_input_match P T t_set t00 t01 t10 t11)
        -> forall pfx, pfx <=| t00
        -> (forall pfx0, pfx0 <=| t00 -> pfx =[G, P] pfx0 -> exists pfx1, pfx1 <=| t01 /\ pfx0 =[G, T] pfx1)
        -> (forall pfx0 pfx1, pfx0 <=| t10 -> pfx1 <=| t11 -> pfx =[G, P] pfx0 -> pfx1 <[G, T] pfx0 -> progress G T pfx1 t11).

    Definition PsTeA (P T : Ensemble Label) : Hyperproperty :=
      fun t_set => forall t00 t01 t10 t11, (nmif_input_match P T t_set t00 t01 t10 t11)
        -> forall pfx, pfx <=| t00
        -> (forall pfx0, pfx0 <=| t00 -> pfx =[G, P] pfx0 -> exists pfx1, pfx1 <=| t01 /\ pfx0 =[G, T] pfx1)
        -> (forall pfx0, pfx0 <=| t10 -> pfx =[G, P] pfx0 -> exists pfx1, pfx1 <=| t11 /\ pfx0 =[G, T] pfx1).

    Definition PsNmifA (P T : Ensemble Label) : Hyperproperty := Intersection Property (PsRdA P T) (PsTeA P T).
    Definition NmPlA (P T : Ensemble Label) : Hyperproperty := Intersection Property (RplA P T) (TpcA P T).

    Definition PsRd : Hyperproperty := fun t_set => forall P T `(Attacker P T), In Property (PsRdA P T) t_set.
    Definition PsTe : Hyperproperty := fun t_set => forall P T `(Attacker P T), In Property (PsTeA P T) t_set.
    Definition NmPl : Hyperproperty := fun t_set => forall P T `(Attacker P T), In Property (NmPlA P T) t_set.
    Definition PsNmif : Hyperproperty := Intersection Property PsRd PsTe.

  End NMIF.

End SecurityDefs.
