# Building and checking Rocq proofs

This archive contains the Rocq definitions and proofs associated with the
paper "Nonmalleable Progress Leakage" authored by Ethan Cecchetti and published at CSF 2025.

Building and checking the proofs requires the following software:
    * coqc, version 8.19 or later (see [the official Rocq downloads page](https://rocq-prover.org/releases))
    * coq_makefile (available the same place as coqc)
    * make (the standard unix/linux utility)

## Compiling

To compile the archive, first generate a Makefile using the following command:
    `coq_makefile -f _CoqProject -o Makefile`

Then build the definitions and proofs by simply running `make`.

## Auditing the Proofs

Definitions are in the `defs/` directory organized as follows.
* The label model and the calculus syntax, semantics, and type system are defined in `defs/Imp.v`
* A coinductive encoding of traces is defined in `defs/Trace.v`
* The definitions of low-equivalence, the security hyperproperties, and attackers are defined in `defs/SecurityDefs.v`
* The definitions of the inference procedure, associated relations, and the restricted label model are in `defs/InferenceDefs.v`

Proofs are in the `theories/` directory. Most of the files are consist almost
entirely of intermediate lemmas that are likely not of interest to many readers.
The following files contain important results and checks for auditing the proofs.
* `theories/ModelAdequacy.v` contains proofs that any definitions that differ between the paper and the code in `defs/` are equivalent.
  This includes the label model itself (the Rocq code uses the fully general version defined in Section II), and the definitions of low-equivalence of events and stores.
* `theories/CoreResults.v` contains proofs of all theorems, propositions, and lemmas stated explicitly in the paper.
  Above each is a comment specifying which claim from the paper they prove.
* `theories/ConvergeDiverge.v` contains an Axiom at the top of the While Trilemma (Lemma 3 in the paper).
  As we note in the paper, this lemma is not provable intuitionistically, and we therefore claim it as an `Axiom`.
  To ensure consistency, `theories/ClassicalTheories.v` contains a proof of the exact same Rocq type using classical assumptions.

Aside from the one `Axiom` mentioned above, there are no uses of `Axiom` or `Admitted`.
We courage anyone auditing the code to `grep` the source files to verify this claim.
