
## theme for ggplot
myTheme <- theme(axis.text = element_text(size = 20), axis.title =  element_text(size = 20),
                 plot.title = element_text(size = 20, hjust = 0.5), legend.text = element_text(size= 18),
                 strip.text = element_text(size = 18, hjust = 0.5),
                 legend.title = element_text(size = 18), legend.background = element_blank())

# setting ggplot theme for rest fo the plots
theme_set(theme_bw())

fancy_scientific <- function(l) {
  # turn in to character string in scientific notation
  l <- format(l, scientific = TRUE)
  # quote the part before the exponent to keep all the digits
  l <- gsub("^(.*)e", "'\\1'e", l)
  # remove + after exponent, if exists. E.g.: (e^+2 -> e^2)
  l <- gsub("e\\+","e",l)  
  # turn the 'e' into plotmath format
  l <- gsub("e", "%*%10^", l)
  # convert 1x10^ or 1.000x10^ -> 10^
  l <- gsub("\\'1[\\.0]*\\'\\%\\*\\%", "", l)
  # return this as an expression
  parse(text=l)
}

log10minorbreaks=as.numeric(1:10 %o% 10^(4:8))


###
###
###
## loading required observed data sets for plotting
Nfd_file <- file.path("data", "Treg_memory_Nfd.csv")
Treg_memory_Nfd <- read.csv(Nfd_file) %>%
  arrange(age.at.S1K) %>%
  mutate(ageBMT_bin = ifelse(age.at.BMT <= 56, 'agebin1',
                             ifelse(age.at.BMT <= 70, 'agebin2',
                                    ifelse(age.at.BMT <= 84, 'agebin3', 'agebin4'))),
         days_postBMT= age.at.S1K - age.at.BMT) %>%
  select(-Popln) %>%
  filter(mouse.ID != 314807)

ki_file <- file.path("data", "Treg_memory_ki.csv")
Treg_memory_ki <- read.csv(ki_file) %>%
  arrange(age.at.S1K) %>%
  mutate(ageBMT_bin = ifelse(age.at.BMT <= 56, 'agebin1',
                             ifelse(age.at.BMT <= 70, 'agebin2',
                                    ifelse(age.at.BMT <= 84, 'agebin3', 'agebin4'))),
         days_postBMT= age.at.S1K - age.at.BMT) %>%
  select(-Popln) %>% rename(Donor = ki_donor, Host = ki_host) %>%
  gather(c(Donor, Host), key = "subcomp", value = "ki_prop") %>%
  filter(mouse.ID != 314806)

###
####
###



# time sequence for predictions specific to age bins within the data
ts_pred1 <- 10^seq(log10(66), log10(450), length.out = 300)
ts_pred2 <- 10^seq(log10(91), log10(450), length.out = 300)
ts_pred3 <- 10^seq(log10(90), log10(450), length.out = 300)
ts_pred4 <- 10^seq(log10(174), log10(450), length.out = 300)
tb_pred1 <- rep(45, 300)
tb_pred2 <- rep(66, 300)
tb_pred3 <- rep(76, 300)
tb_pred4 <- rep(118, 300)



plot_function <- function(fitobject){
  # naive Treg counts in the thymus with 90% envelopes
  Counts_pred <<- as.data.frame(fit, pars = c("counts_mean_pred1", "counts_mean_pred2",
                                             "counts_mean_pred3", "counts_mean_pred4")) %>%
    gather(factor_key = TRUE) %>%
    group_by(key) %>%
    summarize(lb = quantile(value, probs = 0.05),
              median = quantile(value, probs = 0.5),
              ub = quantile(value, probs = 0.95)) %>%
    bind_cols("timeseries" = c(ts_pred1, ts_pred2, ts_pred3, ts_pred4)) %>%
    mutate(ageBMT_bin = ifelse(grepl("pred1", key),"agebin1",
                               ifelse(grepl("pred2", key), "agebin2",
                                      ifelse(grepl("pred3", key), "agebin3", "agebin4"))),
           location = "Thymus") 
  
  # naive Treg counts in the thymus with 90% envelopes
  Counts_withsigma <- as.data.frame(fit, pars = c("counts_pred1", "counts_pred2",
                                                  "counts_pred3", "counts_pred4")) %>%
    gather(factor_key = TRUE) %>%
    group_by(key) %>%
    summarize(lb = quantile(value, probs = 0.16),
              median = quantile(value, probs = 0.5),
              ub = quantile(value, probs = 0.84)) %>%
    bind_cols("timeseries" = c(ts_pred1, ts_pred2, ts_pred3, ts_pred4)) %>%
    mutate(ageBMT_bin = ifelse(grepl("pred1", key),"agebin1",
                               ifelse(grepl("pred2", key), "agebin2",
                                      ifelse(grepl("pred3", key), "agebin3", "agebin4"))),
           location = "Thymus")   
  
  ### selecting rows closest to observed timpoints
  find_nearest_time <- function(test, target_vec){
    target.index <- which(abs(target_vec - test) == min(abs(target_vec - test)))
    target_vec[target.index]
  }
  
  ### selecting rows closest to observed timpoints
  obstimes1 <- sapply(Treg_memory_Nfd$age.at.S1K[Treg_memory_Nfd$ageBMT_bin == "agebin1"],
                      find_nearest_time, target_vec = ts_pred1)
  obstimes2 <- sapply(Treg_memory_Nfd$age.at.S1K[Treg_memory_Nfd$ageBMT_bin == "agebin2"],
                      find_nearest_time, target_vec = ts_pred2)
  obstimes3 <- sapply(Treg_memory_Nfd$age.at.S1K[Treg_memory_Nfd$ageBMT_bin == "agebin3"],
                      find_nearest_time, target_vec = ts_pred3)
  obstimes4 <- sapply(Treg_memory_Nfd$age.at.S1K[Treg_memory_Nfd$ageBMT_bin == "agebin4"],
                      find_nearest_time, target_vec = ts_pred4)
  
  
  Counts_sigma_obs <<- data.frame(ageBMT_bin = c(rep("agebin1", length(obstimes1)),
                                                rep("agebin2", length(obstimes2)),
                                                rep("agebin3", length(obstimes3)),
                                                rep("agebin4", length(obstimes4))),
                                 timeseries = c(obstimes1, obstimes2,
                                                obstimes3, obstimes4)) %>%
    #arrange(ageBMT_bin) %>%
    left_join(Counts_withsigma, by=c("ageBMT_bin", "timeseries")) 
  
  
  # Nfd in thymic naive Tregs with 90% envelopes
  Nfd_pred <<- as.data.frame(fit, pars = c("Nfd_mean_pred1", "Nfd_mean_pred2",
                                          "Nfd_mean_pred3", "Nfd_mean_pred4")) %>%
    gather(factor_key = TRUE) %>%
    group_by(key) %>%
    summarize(lb = quantile(value, probs = 0.05),
              median = quantile(value, probs = 0.5),
              ub = quantile(value, probs = 0.95))  %>%
    bind_cols("timeseries" = c(ts_pred1, ts_pred2, 
                               ts_pred3, ts_pred4))%>%
    #bind_cols("timeseries" = c(ts_pred1-tb_pred1, ts_pred2-tb_pred2, 
    #                          ts_pred3-tb_pred3, ts_pred4-tb_pred4))%>%
    mutate(ageBMT_bin = ifelse(grepl("pred1", key),"agebin1",
                               ifelse(grepl("pred2", key), "agebin2",
                                      ifelse(grepl("pred3", key), "agebin3", "agebin4"))),
           location = "Thymus")   
  
  #Nfd_pred <- rbind(Nfd_pred)
  # naive Treg counts in the thymus with 90% envelopes
  Nfd_withsigma <- as.data.frame(fit, pars = c("Nfd_pred1", "Nfd_pred2",
                                               "Nfd_pred3", "Nfd_pred4")) %>%
    gather(factor_key = TRUE) %>%
    group_by(key) %>%
    summarize(lb = quantile(value, probs = 0.16),
              median = quantile(value, probs = 0.5),
              ub = quantile(value, probs = 0.84))%>%
    bind_cols("timeseries" = c(ts_pred1, ts_pred2, 
                               ts_pred3, ts_pred4))%>%
    #bind_cols("timeseries" = c(ts_pred1-tb_pred1, ts_pred2-tb_pred2, 
    # ts_pred3-tb_pred3, ts_pred4-tb_pred4))%>%
    mutate(ageBMT_bin = ifelse(grepl("pred1", key),"agebin1",
                               ifelse(grepl("pred2", key), "agebin2",
                                      ifelse(grepl("pred3", key), "agebin3", "agebin4"))),
           location = "Thymus")   
  
  
  ### selecting rows closest to observed timpoints
  Nfd_sigma_obs <<- data.frame(ageBMT_bin = c(rep("agebin1", length(obstimes1)),
                                             rep("agebin2", length(obstimes2)),
                                             rep("agebin3", length(obstimes3)),
                                             rep("agebin4", length(obstimes4))),
                              timeseries = c(obstimes1, obstimes2,
                                             obstimes3, obstimes4)) %>%
    #arrange(ageBMT_bin) %>%
    left_join(Nfd_withsigma, by=c("ageBMT_bin", "timeseries")) 
  
  
  
  # Proportion of Ki67hi in donor thymic naive Tregs with 90% envelopes
  ki_donor_pred <- as.data.frame(fit, pars = c("ki_donor_mean_pred1", "ki_donor_mean_pred2",
                                               "ki_donor_mean_pred3", "ki_donor_mean_pred4")) %>%
    gather(factor_key = TRUE) %>%
    group_by(key) %>%
    summarize(lb = quantile(value, probs = 0.05),
              median = quantile(value, probs = 0.5),
              ub = quantile(value, probs = 0.95)) %>%
    bind_cols("timeseries" = c(ts_pred1, ts_pred2, ts_pred3, ts_pred4))%>%
    mutate(ageBMT_bin = ifelse(grepl("pred1", key),"agebin1",
                               ifelse(grepl("pred2", key), "agebin2",
                                      ifelse(grepl("pred3", key), "agebin3", "agebin4"))),
           location = "Thymus", 
           subcomp = 'Donor')   
  
  # naive Treg ki fractions in donor pool in the thymus with 90% envelopes
  ki_donor_withsigma <- as.data.frame(fit, pars = c("ki_donor_pred1", "ki_donor_pred2",
                                                    "ki_donor_pred3", "ki_donor_pred4")) %>%
    gather(factor_key = TRUE) %>%
    group_by(key) %>%
    summarize(lb = quantile(value, probs = 0.16),
              median = quantile(value, probs = 0.5),
              ub = quantile(value, probs = 0.84)) %>%
    bind_cols("timeseries" = c(ts_pred1, ts_pred2, ts_pred3, ts_pred4)) %>%
    mutate(ageBMT_bin = ifelse(grepl("pred1", key),"agebin1",
                               ifelse(grepl("pred2", key), "agebin2",
                                      ifelse(grepl("pred3", key), "agebin3", "agebin4"))),
           location = "Thymus",
           subcomp = 'Donor')
  
  
  ### selecting rows closest to observed timpoints
  obstimes1 <- sapply(Treg_memory_ki$age.at.S1K[Treg_memory_ki$ageBMT_bin == "agebin1"],
                      find_nearest_time, target_vec = ts_pred1)
  obstimes2 <- sapply(Treg_memory_ki$age.at.S1K[Treg_memory_ki$ageBMT_bin == "agebin2"],
                      find_nearest_time, target_vec = ts_pred2)
  obstimes3 <- sapply(Treg_memory_ki$age.at.S1K[Treg_memory_ki$ageBMT_bin == "agebin3"],
                      find_nearest_time, target_vec = ts_pred3)
  obstimes4 <- sapply(Treg_memory_ki$age.at.S1K[Treg_memory_ki$ageBMT_bin == "agebin4"],
                      find_nearest_time, target_vec = ts_pred4)
  
  ### selecting rows closest to observed
  ki_donor_sigma_obs <<- data.frame(ageBMT_bin = c(rep("agebin1", length(obstimes1)),
                                                  rep("agebin2", length(obstimes2)),
                                                  rep("agebin3", length(obstimes3)),
                                                  rep("agebin4", length(obstimes4))),
                                   timeseries = c(obstimes1, obstimes2,
                                                  obstimes3, obstimes4)) %>%
    #arrange(ageBMT_bin) %>%
    left_join(ki_donor_withsigma, by=c("ageBMT_bin", "timeseries"))
  
  # Proportion of Ki67hi in host thymic naive Tregs with 90% envelopes
  ki_host_pred <- as.data.frame(fit, pars = c("ki_host_mean_pred1", "ki_host_mean_pred2",
                                              "ki_host_mean_pred3", "ki_host_mean_pred4")) %>%
    gather(factor_key = TRUE) %>%
    group_by(key) %>%
    summarize(lb = quantile(value, probs = 0.05),
              median = quantile(value, probs = 0.5),
              ub = quantile(value, probs = 0.95)) %>%
    bind_cols("timeseries" = c(ts_pred1, ts_pred2, ts_pred3, ts_pred4))%>%
    mutate(ageBMT_bin = ifelse(grepl("pred1", key),"agebin1",
                               ifelse(grepl("pred2", key), "agebin2",
                                      ifelse(grepl("pred3", key), "agebin3", "agebin4"))),
           location = "Thymus", 
           subcomp = 'Host')    
  
  
  # naive Treg ki fractions in donor pool in the thymus with 90% envelopes
  ki_host_withsigma <- as.data.frame(fit, pars = c( "ki_host_pred1", "ki_host_pred2",
                                                    "ki_host_pred3", "ki_host_pred4")) %>%
    gather(factor_key = TRUE) %>%
    group_by(key) %>%
    summarize(lb = quantile(value, probs = 0.16),
              median = quantile(value, probs = 0.5),
              ub = quantile(value, probs = 0.84)) %>%
    bind_cols("timeseries" = c(ts_pred1, ts_pred2, ts_pred3, ts_pred4)) %>%
    mutate(ageBMT_bin = ifelse(grepl("pred1", key),"agebin1",
                               ifelse(grepl("pred2", key), "agebin2",
                                      ifelse(grepl("pred3", key), "agebin3", "agebin4"))),
           location = "Thymus",
           subcomp = 'Host')
  
  
  ### selecting rows closest to observed
  ki_host_sigma_obs <<- data.frame(ageBMT_bin = c(rep("agebin1", length(obstimes1)),
                                                 rep("agebin2", length(obstimes2)),
                                                 rep("agebin3", length(obstimes3)),
                                                 rep("agebin4", length(obstimes4))),
                                  timeseries = c(obstimes1, obstimes2,
                                                 obstimes3, obstimes4)) %>%
    #arrange(ageBMT_bin) %>%
    left_join(ki_host_withsigma, by=c("ageBMT_bin", "timeseries"))
  
  
  ki_pred <<- rbind(ki_donor_pred, ki_host_pred)
}


