rm(list = ls())  
gc()    
library(loo)
library(tidyverse)
library(gridExtra)
library(kableExtra)

## directories for saving outputs
OutputDir <- file.path('output_fit')

customGreen0 = "#DeF7E9"
customGreen = "#71CA97"
customOrange = "#FF8C00"
customRed = "#FF6347"

## function for exporting a data table of delta loo ic values and akaike weights
#takes 2 separate lists of the name of the models and loo-ic values
model_compare <- function(looiclist){
  # delta loo-ic
  deltaloo_list <- looiclist - min(looiclist)
  ## akaike wt
  akaikewt_numerator <- function(x) exp(-0.5 * x)
  akaikewt_list <- sapply(deltaloo_list, akaikewt_numerator) * 100/sum(exp(- 0.5 * deltaloo_list))
  
  export_table <- data.frame('deltaloo' = round(deltaloo_list, 2),
                             'Akaike_wt' = round(akaikewt_list, 2))
  colnames(export_table)[1:2] <-  c(paste0('\u0394', 'LooIC'),  paste0('Akaike weight ', '\u0025'))
  
  return(export_table)
}

LooDir <- file.path("loo_fit")

### reading the loo objects for each model

### naive Tregs
neutral_file = paste0('loosave_s2Neutral_DeNovo.rds')
Incumbent_file   = paste0('loosave_s2Incumbent_DeNovo.rds')
model_list <- list(
  'Neutral' = readRDS(file.path(LooDir, neutral_file)),
  'Incumbent'   = readRDS(file.path(LooDir, Incumbent_file))
)
compare_mods <- loo_compare(model_list)
print(compare_mods, simplify = F)

compare_mods
loo_mat <- loo_model_weights(model_list, method = 'pseudobma') * 100
loo_mat


### Memory Tregs
LinearDLD_memTreg_naiTreg_file = paste0('loosave_LinearDLD_memTreg_naiTreg.rds')
LinearDLD_memTreg_naive_file   = paste0('loosave_LinearDLD_memTreg_naive.rds')
LinearDLD_memTreg_CM_file      = paste0('loosave_LinearDLD_memTreg_CM.rds')
LinearDLD_memTreg_EM_file     = paste0('loosave_LinearDLD_memTreg_EM.rds')

model_list <- list(
  'LinearDLD_memTreg_naiTreg' = readRDS(file.path(LooDir, LinearDLD_memTreg_naiTreg_file)),
  'LinearDLD_memTreg_naive'   = readRDS(file.path(LooDir, LinearDLD_memTreg_naive_file)),
  'LinearDLD_memTreg_CM'      = readRDS(file.path(LooDir, LinearDLD_memTreg_CM_file)),
  'LinearDLD_memTreg_EM'      = readRDS(file.path(LooDir, LinearDLD_memTreg_EM_file))
  )
compare_mods <- loo_compare(model_list)
print(compare_mods, simplify = F)

compare_mods
loo_mat <- loo_model_weights(model_list, method = 'pseudobma') * 100
loo_mat

loo_tab <- data.frame()
for (i in 1: length(loo_mat)){
  loo_tab[i,"Model weight (%)"] <- loo_mat[i]
}



lootab_export <- loo_tab %>%
  mutate(modname = names(loo_mat),
         Modelname = "Linear model",
         Precursor = ifelse(grepl("naiTreg", modname), "Naive Treg",
                            ifelse(grepl("CM", modname), "Conventional CD4 CM",
                                   ifelse(grepl("EM", modname), "Conventional CD4 EM", "Conventional naive CD4")))) %>%
  arrange(desc(`Model weight (%)`))  %>% mutate_if(is.numeric, ~round(., 1)) %>%
  select(Modelname, Precursor, `Model weight (%)`) %>%
  kable(align=c("l", "l", "c"),
        caption = paste0("Model weights comparing support for CD4 T cell subsets as immediate precursors of memory Treg cells"))  %>%
  #add_header_above(c(" " = 3, "Credible interval" = 2 )) %>%
  #add_header_above(c(" " = 2, "Estimates in days" = 3 )) %>%
  collapse_rows(columns = 1, valign = "top") %>% 
  kable_classic_2(full_width = F) %>% 
  kable_styling(font_size = 16, html_font = "helvetica") #%>%
#footnote(alphabet = "Error bars depict 1 S.D. around the mean estimate")


lootab_export

kableExtra::save_kable(lootab_export, file = paste0("model_support_tab.pdf"))

