﻿using MCRA.Utils.DataFileReading;
using MCRA.Utils.ProgressReporting;
using MCRA.General;

namespace MCRA.Data.Raw.Copying.BulkCopiers {
    public sealed class RelativePotencyFactorsBulkCopier : RawDataSourceBulkCopierBase {

        public RelativePotencyFactorsBulkCopier(
            IDataSourceWriter dataSourceWriter,
            HashSet<SourceTableGroup> parsedTableGroups,
            HashSet<RawDataSourceTableID> parsedDataTables)
            : base(
                  dataSourceWriter,
                  parsedTableGroups,
                  parsedDataTables
        ) {
        }

        public override void TryCopy(IDataSourceReader dataSourceReader, ProgressState progressState) {
            progressState.Update("Processing relative potency factors", 0);

            var hasRpfs = tryDoSimpleBulkCopy(dataSourceReader, RawDataSourceTableID.RelativePotencyFactors);
            if (hasRpfs) {
                progressState.Update("Processing uncertainty tables", 20);
                tryDoSimpleBulkCopy(dataSourceReader, RawDataSourceTableID.RelativePotencyFactorsUncertain);
            }

            if (hasRpfs) {
                registerTableGroup(SourceTableGroup.RelativePotencyFactors);
            }

            progressState.Update(100);
        }
    }
}
