# Code of Conduct

This Code of Conduct supplements Utrecht University's [university-wide Code of Conduct](https://www.uu.nl/en/organisation/about-us/codes-of-conduct) and outlines our expectations for participants within the project. It is adapted from the **Open Life Science** community's [Code of Conduct](https://openlifesci.org/code-of-conduct). 

We welcome everyone to participate in our project. We are committed to providing a friendly and positive environment for all and expect our Code of Conduct to be honored. Although we may fail at times, we seek to treat everyone both as fairly and equally as possible. Whenever a participant has made a mistake, we expect them to take responsibility for it. If someone has been harmed or offended, it is our responsibility to listen carefully and respectfully, and do our best to right the wrong.

## Our Standards

- **Be friendly and patient.**

- **Be welcoming.** We strive to be a community that welcomes and supports people of all backgrounds and identities. This includes, but is not limited to members of any race, ethnicity, culture, national origin, colour, immigration status, social and economic class, educational level, sex, sexual orientation, gender identity and expression, age, size, family status, political belief, religion, and mental and physical ability.

- **Be considerate.** Your work will be used by other people, and you in turn will depend on the work of others. Any decision you take will affect users and colleagues, and you should take those consequences into account when making decisions. Remember that we're a world-wide community, so you might not be communicating in someone else's primary language.

- **Be respectful.** Not all of us will agree all the time, but disagreement is no excuse for poor behavior and poor manners. We might all experience some frustration now and then, but we cannot allow that frustration to turn into a personal attack. It’s important to remember that a community where people feel uncomfortable or threatened is not a productive one. 

- **Be careful in the words that you choose.** We are a community of professionals, and we conduct ourselves professionally. Be kind to others. Do not insult or put down other participants. Harassment and other exclusionary behavior aren't acceptable. This includes, but is not limited to:
  - Violent threats or language directed against another person.
  - Discriminatory jokes and language.
  - Posting sexually explicit or violent material.
  - Posting (or threatening to post) other people's personally identifying information ("doxing").
  - Personal insults, especially those using racist or sexist terms.
  - Unwelcome sexual attention.
  - Advocating for, or encouraging, any of the above behavior.
  - Repeated harassment of others. In general, if someone asks you to stop, then stop.

- **When we disagree, try to understand why.** Disagreements, both social and technical, happen all the time and we are no exception. It is important that we resolve disagreements and differing views constructively. Remember that we're different. Diversity contributes to the strength of our community, which is composed of people from a wide range of backgrounds. Different people have different perspectives on issues. Being unable to understand why someone holds a viewpoint doesn't mean that they're wrong. Don't forget that it is human to err and blaming each other doesn't get us anywhere. Instead, focus on helping to resolve issues and learning from mistakes.

## Reporting Issues

If you experience or witness unacceptable behavior, or have any other concerns, please report it by contacting [Research Data Management Support](https://www.uu.nl/en/research/research-data-management/contact-us).

## Acknowledgements

The following Code of Conduct documents were consulted in addition to that of the Open Life Science community:

- [Django Code of Conduct](https://www.djangoproject.com/conduct/)
- [The Contributor Covenant Code of Conduct, version 2.1](https://www.contributor-covenant.org/version/2/1/code_of_conduct/)
- [The Turing Way Code of Conduct](https://the-turing-way.netlify.app/community-handbook/coc.html)
- [OpenMR Benelux Code of Conduct](https://openmrbenelux.github.io/page-code-of-conduct/)
