# Introduction to Machine Learning in Python

This half-day lesson gives an introduction to common methods and terminologies used in machine learning, with a focus on prediction. We cover areas such as data preparation and resampling, model building, and model evaluation.

It is a prerequisite for the other lessons in the machine learning curriculum. In later lessons we explore tree-based models for prediction, neural networks for image classification, and responsible machine learning.

1. **Introduction to Machine Learning in Python** [[Lesson materials](https://carpentries-incubator.github.io/machine-learning-novice-python/); [Code repository](https://github.com/carpentries-incubator/machine-learning-novice-python)]
2. Introduction to Tree Models in Python [[Lesson materials](https://carpentries-incubator.github.io/machine-learning-trees-python/); [Code repository](https://github.com/carpentries-incubator/machine-learning-trees-python)]
3. Introduction to artificial neural networks in Python [[Lesson materials](https://carpentries-incubator.github.io/machine-learning-neural-python/); [Code repository](https://github.com/carpentries-incubator/machine-learning-neural-python)]
4. Responsible machine learning in Python [[Lesson materials](https://carpentries-incubator.github.io/machine-learning-responsible-python/); [Code repository](https://github.com/carpentries-incubator/machine-learning-responsible-python)]

## Workshop schedule

These lessons are being run at University of Edinburgh as part of the Ed-DaSH Data Science training programme for Health and Biosciences. 

The first lessons were taught in May: https://edcarp.github.io/2022-05-24_ed-dash_machine-learning/. For a list of future lessons, see: https://edcarp.github.io/Ed-DaSH/workshops

## Contributing

We welcome all contributions to improve the lesson! Maintainers will do their best to help you if you have any
questions, concerns, or experience any difficulties along the way.

We'd like to ask you to familiarize yourself with our [Contribution Guide](CONTRIBUTING.md) and have a look at
the [more detailed guidelines][lesson-example] on proper formatting, ways to render the lesson locally, and even
how to write new episodes.

Please see the current list of [issues](https://github.com/carpentries-incubator/machine-learning-novice-python/issues) for ideas for contributing to this
repository. For making your contribution, we use the GitHub flow, which is
nicely explained in the chapter [Contributing to a Project](http://git-scm.com/book/en/v2/GitHub-Contributing-to-a-Project) in Pro Git
by Scott Chacon.
Look for the tag ![good_first_issue](https://img.shields.io/badge/-good%20first%20issue-gold.svg). This indicates that the maintainers will welcome a pull request fixing this issue.


## Maintainer(s)

Current maintainers of this lesson are:

* Tom Pollard ([Website](https://people.csail.mit.edu/tpollard/); [GitHub](https://github.com/tompollard))


## Authors

A list of contributors to the lesson can be found in [AUTHORS](AUTHORS)


## Citation

To cite this lesson, please consult with [CITATION](CITATION)

[cdh]: https://cdh.carpentries.org
[cdh-topic-tags]: https://cdh.carpentries.org/the-carpentries-incubator.html#topic-tags
[change-default-branch]: https://docs.github.com/en/github/administering-a-repository/changing-the-default-branch
[community-lessons]: https://carpentries.org/community-lessons
[lesson-example]: https://carpentries.github.io/lesson-example
