import numpy as np
import matplotlib.pyplot as plt

def load_renorm_data(path):
    dat = np.loadtxt(path)
    r = dat[:,0]
    r = np.append(-r[:0:-1], r)
    ret = [r]
    for i in range(1, dat.shape[1]):
        ret.append(np.append(dat[:0:-1,i], dat[:,i]))
    return np.array(ret).T

data = load_renorm_data('./Data/Densities/density_18_1.txt')
bdg_0 = np.loadtxt('./Data/uv_0.txt')
bdg_2 = np.loadtxt('./Data/uv_2.txt')

fig, ax = plt.subplots(figsize=(2, 1 + 1/2), layout='constrained')
ax.plot(data[:,0], 6*data[:,3], '-', color='black', label='GP')
ax.plot(bdg_0[:,0], bdg_0[:,2]**2, '--', color='red', label='|v|^2')
ax.plot(bdg_2[:,0], bdg_2[:,2]**2, '--', color='green', label='|v|^2')

ax.text(-0.7, 0.50, r'$|v_1|^2$', color='red')
ax.text(0.3, 0.50, r'$|v_2|^2$', color='green')
ax.text(-0.28, 3.0, r'$N|\psi_\mathrm{GP}|^2$', color='black')

ax.set_xticks([-1, 0, 1], ['-R', '0', 'R'])
ax.set_yticks([])
ax.set_xlim(-1, 1)
ax.set_ylim(bottom=0)
ax.set_ylabel('Density')

plt.savefig('./Images/uv.pdf')
plt.savefig('./Images/uv.png')
