import numpy as np
import matplotlib.pyplot as plt

m0bdg = np.loadtxt('./Data/Energies/energies_gpe_bdg_0.txt')
m1bdg = np.loadtxt('./Data/Energies/energies_gpe_bdg_1.txt')
m0mb = np.loadtxt('./Data/Energies/energies_mb_0.txt')
m1mb = np.loadtxt('./Data/Energies/energies_mb_1.txt')

# Plotting energies
fig = plt.figure(figsize=(3+3/8, 2+1/2), layout='constrained')

plt.plot(m0mb[:,0], m0mb[:,1]/6, color='gold', label=r'$L_z = 0$')
plt.plot(m1mb[:,0], m1mb[:,1]/6, color='blue', label=r'$L_z = N\hbar$')

plt.plot(m0bdg[:,0], m0bdg[:,1]/6, '--', color='black', label=r'$\mathrm{GPE}$')
plt.plot(m1bdg[:,0], m1bdg[:,1]/6, '--', color='black')

plt.plot(m0bdg[:,0], m0bdg[:,2]/6, '-.', color='red', label=r'$\mathrm{BdG}$')
plt.plot(m1bdg[:,0], m1bdg[:,2]/6, '-.', color='red')

plt.xlim(0, 18.0)
plt.ylim(bottom=0)
plt.grid(linestyle='--')
plt.ylabel(r'$E/N\ [\hbar^2/2MR^2]$')
plt.xlabel(r'$gN\ [\hbar^2/M]$')
plt.legend(loc='lower right', fontsize='small')
plt.savefig('./Images/energies.pdf')
plt.savefig('./Images/energies.png')

# Plotting the quantum depletion
fig = plt.figure(figsize=(3+3/8, 2+1/2), layout='constrained')

plt.plot(m0mb[:,0], m0mb[:,2], color='gold', label=r'$L_z = 0$')
plt.plot(m1mb[:,0], m1mb[:,2], color='blue', label=r'$L_z = N\hbar$')
plt.plot(m0bdg[:,0], (6.0 + m0bdg[:,3]) / 6.0, '-.', color='red', label=r'$\mathrm{BdG}$')
plt.plot(m1bdg[:,0], (6.0 + m1bdg[:,3]) / 6.0, '-.', color='red')

plt.xlim(0, 18.0)
# plt.ylim(tom=1.2)
plt.grid(linestyle='--')
plt.ylabel(r'$\lambda_0$')
plt.xlabel(r'$gN\ [\hbar^2/M]$')
plt.legend(loc='lower left', fontsize='small')
plt.savefig('./Images/depletion.pdf')
plt.savefig('./Images/depletion.png')
