import numpy as np
import matplotlib.pyplot as plt

def load_renorm_data(path):
    dat = np.loadtxt(path)
    r = dat[:,0]
    r = np.append(-r[:0:-1], r)
    ret = [r]
    for i in range(1, dat.shape[1]):
        ret.append(np.append(dat[:0:-1,i], dat[:,i]))
    return np.array(ret).T

def default_plotting(axis, path, use_meanfield=True, color='blue'):
    dat = load_renorm_data(path)
    r = dat[:,0]
    rho = dat[:,1] / 6
    axis.plot(r, rho, color=color)
    if use_meanfield:
        mf = dat[:,3]
        axis.plot(r, mf, '--', color='black')
    axis.set_xlim(-1, 1)
    axis.set_ylim(bottom=0)
    axis.set_xticks([-1,0,1], ['-R', '0', 'R'])
    axis.set_yticks([])

def quickplot_densities(identifier, **kwargs):
    _, axs = plt.subplots(2, 2, figsize=(3+3/8, 3), layout='constrained')
    default_plotting(axs[0,0], './Data/Densities/density_0_' + identifier + '.txt', **kwargs)
    default_plotting(axs[0,1], './Data/Densities/density_6_' + identifier + '.txt', **kwargs)
    default_plotting(axs[1,0], './Data/Densities/density_12_' + identifier + '.txt', **kwargs)
    default_plotting(axs[1,1], './Data/Densities/density_18_' + identifier + '.txt', **kwargs)
    axs[0,0].set_title(r'$gN = 0$')
    axs[0,1].set_title(r'$gN = 6$')
    axs[1,0].set_title(r'$gN = 12$')
    axs[1,1].set_title(r'$gN = 18$')
    axs[0,0].set_ylabel(r'Density')
    axs[1,0].set_ylabel(r'Density')
    axs[0,0].set_xticks([])
    axs[0,1].set_xticks([])
    plt.savefig('./Images/densities_' + identifier + '.pdf')
    plt.savefig('./Images/densities_' + identifier + '.png')

quickplot_densities('0', color='gold')
quickplot_densities('1', color='blue')
quickplot_densities('Nh', color='forestgreen', use_meanfield=False)
