import numpy as np
import matplotlib.pyplot as plt

data = np.loadtxt('./Data/convergence_cutoffs.txt')

fig, axs = plt.subplots(1, 2, figsize=(3+3/8, 1+1/2), layout='constrained')
axs[0].plot(1.0/data[:,0], data[:,1], '--x', color='black', markersize=2.5, linewidth=0.5)

axs[0].set_xscale('log')
axs[0].grid(linestyle='--', linewidth=0.5)
axs[0].set_xlabel(r'$1/E_{\mathrm{cut}}$', fontsize=8)
axs[0].set_ylabel(r'$E_0$', fontsize=8)
axs[0].tick_params(labelsize=6)

# Linear fit of the exponential convergence
einf = np.min(data[:,1])
axs[1].plot(data[:-1,0], (data[:-1,1]-einf)/einf, '--x', color='black', markersize=2.5, linewidth=0.5)
# Set ticks labels font size
axs[1].grid(linestyle='--', linewidth=0.5)
axs[1].set_xlabel(r'$E_{\mathrm{cut}}$', fontsize=8)
axs[1].set_ylabel(r'$(E_0 - E_{\mathrm{min}})/E_{\mathrm{min}}$', fontsize=8)
axs[1].set_yscale('log')
axs[1].tick_params(labelsize=6)


plt.savefig('./Images/convergence.pdf')
plt.savefig('./Images/convergence.png')
