import numpy as np
import scipy as sp
import matplotlib.pyplot as plt

def bes_val(x, m, n):
    zero = sp.special.jn_zeros(m, n)[-1]
    norm_fac = np.abs(sp.special.jv(m+1,zero))*np.sqrt(np.pi)
    y = sp.special.jv(m, x*zero)/norm_fac
    return y

x = np.linspace(0, 1, 100)

colors = ['darkred', 'tomato', 'gold']

fig, axs = plt.subplots(1, 2, figsize=(3+3/8, 2), layout='constrained')

axs[0].axhline(0, lw=1.0, color='lightgrey', linestyle='--')
axs[1].axhline(0, lw=1.0, color='lightgrey', linestyle='--')

for i in range(3):
    y0 = bes_val(x, 0, i+1)
    y1 = bes_val(x, 1, i+1)
    axs[0].plot(x, y0, color=colors[i])
    axs[1].plot(x, y1, color=colors[i])

axs[0].set_xlim(0, 1)
axs[1].set_xlim(0, 1)
axs[0].set_ylim(-1, 2.5)
axs[1].set_ylim(-1, 2.5)

axs[0].text(0.5, 2.0, r'$m_j=0$', color='black', ha='center')
axs[1].text(0.5, 2.0, r'$m_j=1$', color='black', ha='center')

axs[0].set_xticks([0, 1], ['0', 'R'])
axs[1].set_xticks([0, 1], ['0', 'R'])

axs[1].set_yticks([])

axs[0].set_ylabel(r'$A_j\;J_{m_j}\left(\alpha_jr/R\right)$')

plt.savefig('./Images/bessels.pdf', bbox_inches='tight')
plt.savefig('./Images/bessels.png', bbox_inches='tight')
