#ifndef HELP_CORE_HASHES_H
#define HELP_CORE_HASHES_H

#include "type_defs.h"
#include <vector>

namespace std {
// roughly: https://stackoverflow.com/questions/20511347/a-good-hash-function-for-a-vector
template <typename T>
struct hash<std::vector<T>> {
    std::size_t operator()(const std::vector<T> &n_ids) const noexcept {
        std::size_t seed = n_ids.size();
        for (auto &_x : n_ids) {
            std::size_t x = std::hash<T>{}(_x);
            x = ((x >> 16) ^ x) * 0x45d9f3b;
            x = ((x >> 16) ^ x) * 0x45d9f3b;
            x = (x >> 16) ^ x;
            seed ^= x + 0x9e3779b9 + (seed << 6) + (seed >> 2);
        }
        return seed;
    }
};

template <typename T>
struct hash<std::set<T>> {
    std::size_t operator()(const std::set<T> &s) const noexcept {
        return hash<std::vector<T>>{}(std::vector<T>(s.begin(), s.end()));
    }
};

template <typename T1, typename T2>
struct hash<std::pair<T1, T2>> {
    std::size_t operator()(const std::pair<T1, T2> &p) const noexcept {
        return hash<T1>{}(p.first) ^ hash<T2>{}(p.second);
    }
};
}

#endif  // HELP_CORE_HASHES_H
