#ifndef HELP_CORE_COMMON_FUNC_H
#define HELP_CORE_COMMON_FUNC_H

#include <vector>

// roughly https://stackoverflow.com/questions/68400844/how-to-get-the-index-of-an-element-of-a-stdvector-from-the-reference-to-one-of
template <class T>
std::size_t get_vec_index(std::vector<T> const &vec, T const &item) {
    T const *data = vec.data();

    assert(!(std::less<T const *>{}(&item, data) || std::greater_equal<T const *>{}(&item, data + vec.size())));

    return static_cast<std::size_t>(&item - vec.data());
};

#endif  // HELP_CORE_COMMON_FUNC_H
