#include <cassert>
#include "lifted_strips_task.h"
#include "../conj_query_eval/join_order_generator/join_order_generator.h"
namespace HELP { 

//#include "../conj_query_eval/join_and_project.h"

template<typename T>
void LiftedStripsTask::dump_dl_repr(const std::vector<T> &v, std::ostream &outs) {
    size_t i = 0;
    size_t no_comma = v.size()-1;
    for (auto &element : v) { //TODO: combine with next func, can simply use template
        dump_dl_repr(element, outs);
        if (i != no_comma) {
            outs << ", ";
        }
        i++;
    }
}

//TODO: bad return type
inline std::pair<QueryEval::Query, Parameters> create_query(Action &action, DBInfo &info) {
    Parameters result_pars = action.get_eff_pars();
    std::vector<Atom> pre_copy = action.get_pre();
    return std::make_pair(QueryEval::Query(pre_copy, result_pars, info), result_pars);
}

//TODO: bad return types
inline std::tuple<QueryEval::JoinOrder, QueryEval::Query, Parameters> create_join_order(Action &action, DBInfo &info) { //TOOD: move this, rename
    auto [query, result_pars] = create_query(action, info); //TODO: allow to pass const ref
    return {QueryEval::create_join_order(query), query, result_pars};
}

//TODO: bad return types
std::tuple<QueryEval::AnnotatedJoinOrder, QueryEval::Query, Parameters> create_annoted_join_order(Action &action, DBInfo &info) {
    auto [join_order, query, result_pars] = create_join_order(action, info);
    auto annotated_join_order = QueryEval::annotate(query, join_order); //TODO: always order this in the same way
    return {annotated_join_order, query, result_pars};
}


inline std::tuple<std::vector<QueryEval::JoinOrderGraph::ExtNodeRepr>, QueryEval::Query, Parameters> create_join_graph(Action &action, DBInfo &info) {
    auto [annotated_join_order, query, results_pars] = create_annoted_join_order(action, info);
    auto *graph = new QueryEval::JoinOrderGraph(query, annotated_join_order, info); //TODO: very unpretty, memory leak

    return {graph->get_nodes(), query, results_pars};
}


//TODO: all of this below seems far to complicated for what it is

template<typename T> //TODO: provide a functionality like this via util
struct join_order_transform_t_struct { //By standard do not transform
    typedef T type;
};

template<>
struct join_order_transform_t_struct<QueryEval::JoinOrderElement> {
    typedef PrintableJoinOrderEl type;
};

template<>
struct join_order_transform_t_struct<QueryEval::AnnotatedJoinOrderElement> {
    typedef PrintableAnnotatedJoinOrderEl type;
};

template<typename T>
using join_order_transform_t = typename join_order_transform_t_struct<T>::type;

template<typename T>  //By standard do not transform
inline join_order_transform_t<T> transform_join_order_el(T &el, QueryEval::Query &query, Action &action) {
    return el;
}

template<>
inline PrintableJoinOrderEl transform_join_order_el(QueryEval::JoinOrderElement &el, QueryEval::Query &query, Action &action) {
    return {query.get_atom(el.from_id), query.get_atom(el.to_id)};
}

inline std::vector<const Parameter*> to_par_name(std::vector<ParRef> &refs, Action &action) {
    std::vector<const Parameter*> pars;
    for (auto &ref : refs) {
        pars.push_back(&action.get_var_name(ref));
    }
    return pars;
}

template<>
inline PrintableAnnotatedJoinOrderEl transform_join_order_el(QueryEval::AnnotatedJoinOrderElement &el, QueryEval::Query &query, Action &action) {
    auto join_pars = to_par_name(el.pars_joined, action);
    auto tracked_pars = to_par_name(el.pars_tracked, action);
    return {transform_join_order_el(el.element, query, action), join_pars, tracked_pars};
}

//TODO: bad return types
template<typename T> //TODO hacky
inline std::vector<join_order_transform_t<T>> join_order_transform(std::vector<T> &join_order, QueryEval::Query &query, Action &action) { //TODO: void
    std::vector<join_order_transform_t<T>> res;
    for (auto &el : join_order) {
        res.push_back(transform_join_order_el(el, query, action));
    }
    return res;
}


//TODO: rename this to whatever it became, probably some generic action info thing
template<typename JoinOrderEl, std::tuple<std::vector<JoinOrderEl>, QueryEval::Query, Parameters> create_join_order(Action &action, DBInfo &info)>
void LiftedStripsTask::_print_join_orders(std::ostream &outs) {
    //TODO: maybe warning to just use this for debbuging/whatever?
    DBInfo info = get_info();
    for (auto &action : actions) {
        dump_dl_repr(action, outs);
        outs << std::endl;
        outs << "order: "; //TODO: appropriate name by template

        auto [join_order, query, result_pars] = create_join_order(action, info);
        auto printable_join_order = join_order_transform(join_order, query, action);

        dump_dl_repr(printable_join_order, outs);
        outs << std::endl << std::endl;
    }
}

}