#ifndef HELP_CORE_DB_SHARED_H
#define HELP_CORE_DB_SHARED_H

#include "../utils/type_defs.h"
#include <vector>
#include <unordered_set>
#include <map>
#include <string>
#include <set>
#include <limits.h>

namespace HELP { 

typedef ll ParRef; //TODO: wrap ll
typedef std::vector<ParRef> Parameters;

template<typename T>
inline void multiple_set_union(std::set<T> &res, std::vector<std::set<T>> &multiple_sets) { //TODO: move to util TODO allow more than vec
    for (auto &current_set : multiple_sets) { //TODO: is there a better implementation using set union? -- https://stackoverflow.com/questions/7089494/merge-multiple-sets-elements-in-a-single-set
        res.insert(current_set.begin(), current_set.end());
    }
}

class Predicate {
    std::string name;
    ll arity;

public:
    Predicate(std::string name, ll arity) : name(name), arity(arity) {}

    ll get_arity() const {
        return arity;
    }

    void set_unary() {
        arity = 1;
    }

    const std::string &get_name() {
        return name;
    }

    bool is_nullary() {
        return get_arity() == 0;
    }
};

class Object {
    std::string name;

public:
    Object(std::string name) : name(name) {} //TODO: ref

    const std::string &get_name() {
        return name;
    }
};

constexpr size_t ll_size_minus(size_t i) { // TODO: move to globs
    return sizeof(ll) * CHAR_BIT - i;
}

class ParameterOrObject {
    ll _is_variable : 1; //TODO: commonly name variable or parameter
    ll index : ll_size_minus(1);
public:
    bool is_variable() const {
        return _is_variable;
    }

    bool is_object() const {
        return !is_variable();
    }

    ll get_index() const {
        return index;
    }

    ParameterOrObject(bool _is_variable, ll index) : _is_variable(_is_variable), index(index) {}
};

class Atom {
    ll negated : 1;
    ll predicate_id : ll_size_minus(1);
    std::vector<ParameterOrObject> args; //TODO: important -- no longer needed if normalized

public:
    bool is_negated() const {
        return negated;
    }

    ll get_predicate() const {
        return predicate_id;
    }

    const std::vector<ParameterOrObject> &get_args() const {
        return args;
    }

    std::set<ParRef> create_pars() { //TODO: make void
        std::set<ParRef> pars;
        for (auto &arg : get_args()) {
            if (arg.is_variable()) {
                pars.insert(arg.get_index());
            }
        }
        return pars;
    }

    bool has_constants() { //TODO: is this unused now?
        for (auto &arg : args) {
            if (arg.is_object()) {
                return true;
            }
        }

        return false;
    }

    size_t get_arity() {
        return args.size();
    }

    bool is_nullary() {
        return args.empty();
    }

    void make_unary(ll t_par) {
        if (args.empty()) {
            args = {{true, t_par}};
        }
    }

    void make_unary_const(ll t_const) {
        if (args.empty()) {
            args = {{false, t_const}};
        }
    }

    Atom() {}

    Atom(ll predicate_id, std::vector<ParameterOrObject> args) : Atom(false, predicate_id, args) {}

    Atom(bool negated, ll predicate_id, std::vector<ParameterOrObject> args) : negated(negated), predicate_id(predicate_id), args(args) {}
};

inline std::vector<std::set<ParRef>> pars_per(std::vector<Atom> &atoms){ //TODO: void
    std::vector<std::set<ParRef>> pars_per_atom;
    for (auto &atom : atoms) {
        pars_per_atom.push_back(atom.create_pars());
    }
    return pars_per_atom;
}

inline std::set<ParRef> all_pars(std::vector<std::set<ParRef>> &pars_per_atom) { //TODO: void - can we create custom warnings for this?
    std::set<ParRef> result;
    multiple_set_union(result, pars_per_atom);
    return result;
}

inline std::set<ParRef> all_pars(std::vector<Atom> &atoms) {
    auto pars_per_atoms = pars_per(atoms);
    return all_pars(pars_per_atoms);
};

inline ll max_par(std::set<ParRef> &s) {
    if (!s.empty()) {
        return *s.rbegin();
    }

    return -1; //TODO: hacky, but used for correct par amount
}

inline ll max_par(std::vector<std::set<ParRef>> &pars_per_atom) { //TODO: void
    std::set<ParRef> all_p = all_pars(pars_per_atom);
    return max_par(all_p);
}

typedef ll ObjectRef;

class GroundAtom { // TODO: shared super with normal atom?
    ll predicate_id;
    std::vector<ObjectRef> args;
public:
    GroundAtom(ll predicate_id, std::vector<ObjectRef> args) : predicate_id(predicate_id), args(args) {}

    ll get_predicate() const {
        return predicate_id;
    }

    const std::vector<ObjectRef> &get_args() const {
        return args;
    }

    void make_unary_if_nullary(ll artf_obj_id) {
        if (args.empty()) {
            args = {artf_obj_id};
        }
    }
};

class GroundAtomCol { // Col for Collection
    std::unordered_set<ll> non_empty_preds;
    std::vector<std::vector<GroundAtom>> repr;
public:
    GroundAtomCol() {}
    GroundAtomCol(std::vector<GroundAtom> &repr, size_t pred_am) : repr(pred_am) {
        for (auto &atom : repr) {
            insert(atom);
        }
    }

    std::vector<GroundAtom> transform_to_vec() { //TODO: get rid of this
        std::vector<GroundAtom> res;

        for (auto &v : repr) {
            for (auto &el : v) {
                res.push_back(el);
            }
        }

        return res;
    }

    void remove_nullary(ll artf_obj_id) {
        for (auto &v : repr) {
            for (auto &atom: v) {
                atom.make_unary_if_nullary(artf_obj_id);
            }
        }
    }

    void change_size(size_t to) {
        repr.resize(to);
    }

    void insert(GroundAtom &atom) {
        auto &container = repr[atom.get_predicate()];

        if (container.empty()) {
            non_empty_preds.insert(atom.get_predicate());
        }

        container.push_back(atom);
    }

    const std::vector<GroundAtom> &get_atoms(ll predicate) {
        return repr.at(predicate);
    }

    auto get_pred_am() const {
        return repr.size();
    }

    auto &get_non_empty_preds() {
        return non_empty_preds;
    }
};

struct DBInfo {
    ll object_amount;
    ll predicate_amount;
    //TODO important should be unordered
    std::set<ll> static_predicates;
    std::map<ll, ll> most_duplicated;
    std::map<ll, ll> init_table_size;
};

}

#endif //HELP_CORE_DB_SHARED_H
