#include <string>
#include "cmd_opts/cmd_opt.h"
#include "sstream"
#include "input_handling/lexer/lexer.h"
#include "input_handling/parser/argparser/arg_parser.h"

namespace HELP { 

// TODO: maybe wanna move the code into something like "argparser"/"optparser" file
std::map<std::string, std::string> get_additional_flags(std::string& s) {
    if (s.empty()) {
        return std::map<std::string, std::string>();
    }

    std::stringstream str_s;
    str_s << s;

    Lexer::Lexer lexer(str_s);
    auto &repr = lexer.lex_and_get_repr();
    return ArgParser(repr).parse_and_get_repr();
}

bool is_flag(std::string &s) {
    return s.starts_with("--");
}

Opt &get_opt(std::string &s) {
    return opt_storage[s];
}

}

int main(int argc, char* argv[]) {
    if (argc == 1) {
        HELP::log_help_and_end();
    }

    for (int i = 1; i < argc; i++) {
        std::string s(argv[i]);
        HELP::cmd_error_if(!HELP::is_flag(s), "TODO"); //TODO: err msg, create own function?

        std::string s_next;
        if (i+1 < argc) {
            std::string pot_next(argv[i+1]);
            if (!HELP::is_flag(pot_next)) {
                s_next = pot_next;
                i++;
            }
        }

        auto add_flags = HELP::get_additional_flags(s_next);
        HELP::get_opt(s).execute(add_flags);
    }

    //TODO: if was empty, display help

    return 0;
}