#ifndef FAST_BACKWARD_LOGGER_H
#define FAST_BACKWARD_LOGGER_H

#include <iostream>
#include <memory>

namespace HELP { 

class StringBuilder {
public:
    virtual std::string build_str() = 0;
    virtual ~StringBuilder() = default;
};

class TrivialStringBuilder : public StringBuilder { //TODO: can just use stringview
    std::string s;
public:
    TrivialStringBuilder(std::string s) : s(s) {}

    virtual std::string build_str() override {
        return s;
    }
};

namespace Logger {
    inline void log(std::string s) { //TODO: combine with below
        std::cout << s << std::endl;
    }

    inline void error(std::vector<std::shared_ptr<StringBuilder>> str_builder) { //TODO: should probably not look like this and be a const expr
#ifndef ULTIMATE_PERFORMANCE //TODO: is this really relevant for control flow analysis?
        for (auto &builder : str_builder) {
            std::cerr << builder->build_str() << std::endl; //TODO: could probably also just pass
        }
        std::cerr << std::endl;
        exit(1);

        //TODO: print stack trace
#endif
    }

    inline void error(std::string s) { //TODO: should probably not look like this and be a const expr
        error({std::make_shared<TrivialStringBuilder>(s)});
    }

    inline void error_if(bool condition, std::vector<std::shared_ptr<StringBuilder>> str_builder) { //TODO: delete needs lazy eval
        if (condition) {
            error(str_builder);
        }
    }
};

}

#endif