#include <string>
#include <vector>
#include "parser.h"

namespace HELP { 

// TODO: set Logger Mode (also in lexer)

// TODO: should probably split this into two classes,
// TODO: one to handle current repr, no template,
// TODO: one to handle out repr, template

template<typename ReprT>
Parser<ReprT>::Parser(std::vector<std::shared_ptr<Lexer::Token>> &lex_repr) : lex_repr(lex_repr) { }

template<typename ReprT>
bool Parser<ReprT>::current_is_str_type() {
    return get_current()->is_string_type();
}

template<typename ReprT>
bool Parser<ReprT>::current_is_number() {
    return get_current()->is_number();
}

template<typename ReprT>
void Parser<ReprT>::io_check(bool b, std::string msg, Lexer::Token *t) {
    if (!t) {
        t = &*get_current(); //TODO: this is hacky
    }
    InputHandler::io_check(!b, msg, t->get_position()); //TODO: this is so hacky (!b)
}

template<typename ReprT>
void Parser<ReprT>::check_and_consume(bool b, std::string msg, Lexer::Token *t) {
    io_check(b, msg, t);
    consume();
}

template<typename ReprT>
bool Parser<ReprT>::next_is(Lexer::TOKEN_TYPE t) {
    return pos < lex_repr.size() - 1 && get_next()->is_type(t);
}

template<typename ReprT>
bool Parser<ReprT>::repr_searched() {
    assert(pos <= lex_repr.size());
    return pos == lex_repr.size();
}

template<typename ReprT>
void Parser<ReprT>::consume() {
    assert(pos < lex_repr.size());
    pos++;
}

template<typename ReprT>
ReprT &Parser<ReprT>::get_repr() {
    return parser_repr;
}

template<typename ReprT>
ReprT &Parser<ReprT>::parse_and_get_repr() {
    parse();
    return get_repr();
}

template<typename ReprT>
std::shared_ptr<Lexer::Token> Parser<ReprT>::get_next() {
    assert(pos < lex_repr.size()-1);
    return lex_repr[pos+1];
}

template<typename ReprT>
std::shared_ptr<Lexer::Token> Parser<ReprT>::get_current() {
    assert(pos < lex_repr.size());
    return lex_repr[pos];
}

template<typename ReprT>
bool Parser<ReprT>::current_is(Lexer::TOKEN_TYPE t) {
    return get_current()->is_type(t);
}

template<typename ReprT>
bool Parser<ReprT>::almost_end() {
    return pos == lex_repr.size()-1;
}

template<typename ReprT>
bool Parser<ReprT>::is_end() {
    return pos >= lex_repr.size();
}


template<typename ReprT>
ll Parser<ReprT>::get_current_num() {
    assert(get_current()->is_number());
    return std::static_pointer_cast<Lexer::NumberToken>(get_current())->get_num();
}

template<typename ReprT>
std::string Parser<ReprT>::get_current_string() {
    assert(get_current()->is_string_type());
    return std::static_pointer_cast<Lexer::StringToken>(get_current())->get_string();
}

template<typename ReprT>
bool Parser<ReprT>::current_is_identifierable() {
    return current_is(Lexer::ID) || get_current()->identifierable();
}

template<typename ReprT>
void Parser<ReprT>::string_transform() { //TODO: rename id transform
    if (get_current()->identifierable()) {
        lex_repr[pos] = std::make_shared<Lexer::StringToken>(to_id_token(*get_current())); //TODO: is this appr or should we return & shared pointer?
    }
    assert(current_is(Lexer::ID));
}

}