#ifndef FAST_BACKWARD_PARSER_H
#define FAST_BACKWARD_PARSER_H

#include "parser.h"
#include "../lexer/token.h"
#include "../input_handler.h"

#include <map>


namespace HELP { 

//TODO: no full template, make runner, use alias https://stackoverflow.com/questions/3053561/how-do-i-assign-an-alias-to-a-function-name-in-c
template<typename ReprT>
class Parser : public InputHandler {
protected:
    int pos = 0;
    std::vector<std::shared_ptr<Lexer::Token>>& lex_repr;
    ReprT parser_repr;//TODO: call return argmap or something like this? (also the type)

    std::shared_ptr<Lexer::Token> get_current();
    std::shared_ptr<Lexer::Token> get_next();
    bool current_is(Lexer::TOKEN_TYPE t);
    bool next_is(Lexer::TOKEN_TYPE t);
    bool current_is_str_type();
    bool current_is_identifierable();
    bool current_is_number();
    bool repr_searched();
    bool almost_end();
    bool is_end();
    ll get_current_num();
    std::string get_current_string();

    void string_transform();
    void consume();

    void io_check(bool b, std::string msg, Lexer::Token *t=nullptr);
    void check_and_consume(bool b, std::string msg, Lexer::Token *t=nullptr);

public:
    explicit Parser(std::vector<std::shared_ptr<Lexer::Token>> &lex_repr);
    virtual void parse() = 0;
    ReprT &get_repr(); //TODO: combine with lexer
    ReprT &parse_and_get_repr(); //TODO: combine with lexer
};

}

#include "parser.tpp"

#endif