#ifndef FAST_BACKWARD_DATALOG_PARSER_H
#define FAST_BACKWARD_DATALOG_PARSER_H

#include "../parser.h"
#include "../../../task_formulations/lifted_strips_task.h"

namespace HELP { 

class DatalogParser : public Parser<LiftedStripsTask> {
    ll current_cost;
    std::map<std::string, ll> predicates; //TODO: prob. should use unordered_maps
    std::map<std::string, ll> objects;
    std::map<std::string, ll> rule_vars;

    std::map<ll, ll> predicate_arity; //TODO: could also be vec

    std::string current_atom_pred;
    std::vector<std::string> current_atom_args;

    Atom rule_head;
    std::vector<Atom> rule_body;

    std::vector<GroundAtom> i_state_list;
    Actions rules;

    std::vector<std::string> to_vec(std::map<std::string, ll>& m); //TODO: should be part of shared data structure for indexing

    ll get_predicate(std::string &s);
    ll get_variable(std::string &s);
    ll get_object(std::string &s);
    std::vector<ParameterOrObject> get_current_args(); //TODO: ret type as ref
    Atom get_current_atom(); //TODO: ret type as ref
    Objects get_current_objects(); //TODO: ret type as ref
    Predicates get_current_predicates(); //TODO: ret type as ref

    bool is_variable(std::string &s);
    GroundAtom to_grounded(Atom atom); //TODO: input and return type as ref
    Action get_current_action();

    void parse() override;
    void parse_atom_line();

    void parse_line_end();
    void parse_atom_list();
    void parse_atom();
    void parse_rule();

    //TODO: rename
    void move_atom_to_head(); // to rule head
    void move_atom_to_list(); // to rule body
    void move_atom_to_i_state(); // to init state
    void move_rule_to_list(); // to rule collection

    // TODO: remove templates, move into parser
    template<typename T>
    void consume_value(T& val);

    template<typename T>
    void consume_bind(T& val);

    void consume_check(Lexer::TOKEN_TYPE token_t);

    void build_task();

    template<typename T>
    void bind(T& val);

    template<typename T> //TODO: why does above not match?
    void bind(std::vector<T>& val);

    template<typename T>
    T get_val(); //TODO: rename to contain current

public:
    using Parser<LiftedStripsTask>::Parser;
};

}

#endif