#include "datalog_parser.h"
#include <string>
#include <type_traits>

namespace HELP {

using namespace Lexer;

//TODO: make sure @goal-reachable is in goal
constexpr auto GOAL_PREDICATE = "@goal-reachable";

// from: https://stackoverflow.com/questions/40626433/c-how-to-specialize-a-template-using-vectort
//TODO: move to util
template<typename T>
struct is_vector
{
    static constexpr bool value = false;
};

template<template<typename...> class C, typename U>
struct is_vector<C<U>>
{
    static constexpr bool value =
            std::is_same<C<U>,std::vector<U>>::value;
};

// ====

//TODO: could define publcly and just take shortcuts: https://stackoverflow.com/questions/48159512/alias-for-preprocessor-methods-in-c

//TODO: can template assign here? (also next)

// TODO: assert token t should either be part of paser or token files
template<typename T>
bool _assert_token_t(Lexer::Token &t);

template<>
bool _assert_token_t<ll>(Token &t) {
    return t.is_number();
};

template<>
bool _assert_token_t<std::string>(Token &t) { //TODO: it feels like there is a lot cleaner solution via the types, should think of that  and remove all is_string_type thingys, no?
    return t.is_string_type();
};

template<typename T> //TODO: maybe wanna support more than just vec?
std::enable_if_t<is_vector<T>::value, bool> assert_token_t(Token &t) {
    return _assert_token_t<typename T::value_type>(t);
};

template<typename T>
std::enable_if_t<!is_vector<T>::value, bool> assert_token_t(Token &t) {
    return _assert_token_t<T>(t);
};

// TODO: these defines into common parser include
template<>
ll DatalogParser::get_val<ll>(){
    return get_current_num();
};

// TODO: these defines into common parser include
template<>
std::string DatalogParser::get_val<std::string>(){
    return get_current_string();
};

template<typename T>
void DatalogParser::bind(T &val){
    val = get_val<T>();
};

template<typename T>
void DatalogParser::bind(std::vector<T> &v){
    v.push_back(get_val<T>());
};

// TODO: these defines into common parser include
template<typename T>
void DatalogParser::consume_value(T& val) {
    bind(val);
    consume();
}

template<typename T>
void DatalogParser::consume_bind(T& val) {
    if (assert_token_t<T>(*get_current())) {
        consume_value(val);
    } else {
        io_error("TODO: err mssg regarding type expected", get_current()->get_position()); //TODO: wrap get current get position
    }
}

void DatalogParser::consume_check(Lexer::TOKEN_TYPE token_t) {
    if (get_current()->is_type(token_t)) {
        consume();
    } else {
        io_error("TODO: err msg regarding value expected", get_current()->get_position()); //TODO: wrap get current get position
    }
}

void DatalogParser::parse_line_end() {
    consume_check(LBRACKET);
    consume_bind(current_cost);
    consume_check(RBRACKET);
    consume_check(Lexer::DOT);
}

void DatalogParser::parse_atom() {
    string_transform(); //TODO: doing this without err handling just plain seems very hacky
    consume_bind(current_atom_pred); //TODO: will also consume vars -- wrong
    consume_check(Lexer::LPAREN);
    while (!current_is(Lexer::RPAREN)) {
        consume_bind(current_atom_args);
        if (current_is(Lexer::COMMA)) { //TODO: accepts ,) -- that is okay, isn't it?
            consume();
        }
    }
    consume();
}

void DatalogParser::parse_atom_list() { //TODO: combine with (...) arg parsing
    if (current_is(Lexer::LBRACKET)) {
        return;
    }
    parse_atom();
    move_atom_to_list();
    while (current_is(Lexer::COMMA)) {
        consume();
        parse_atom();
        move_atom_to_list();
    }
}

void DatalogParser::parse_rule() {
    consume_check(Lexer::DL_RULE_TYPE);
    parse_atom();
    move_atom_to_head();
    consume_check(Lexer::DL_RULE_SPECIFIER);
    parse_atom_list();
    parse_line_end();
    move_rule_to_list();
}

void DatalogParser::parse_atom_line() {
    parse_atom();
    move_atom_to_i_state(); // no vars allowed
    parse_line_end();
    assert(current_cost == 0);
}

void DatalogParser::parse() {
    while (!is_end()) {
        if (current_is_identifierable()) { //TODO: rn is identifier
            parse_atom_line();
        } else if (current_is(Lexer::DL_RULE_TYPE)) {
            parse_rule();
        } else {
            io_error("TODO: invalid line start", get_current()->get_position()); //TODO: wrap get current get position
        }
    }

    build_task();
}

ll DatalogParser::get_predicate(std::string &s) { //TODO: could create a datastructure for this, i need this so often in so many ways
    auto pred = predicates.find(s);
    if (pred == predicates.end()) {
        predicates.insert({s, predicates.size()});
        pred = predicates.find(s);
    }

    return pred->second;
}

ll DatalogParser::get_variable(std::string &s) { //TODO: could create a datastructure for this, i need this so often in so many ways
    auto var = rule_vars.find(s);
    if (var == rule_vars.end()) {
        rule_vars.insert({s, rule_vars.size()});
        var = rule_vars.find(s);
    }

    return var->second;
}

ll DatalogParser::get_object(std::string &s) { //TODO: could create a datastructure for this, i need this so often in so many ways
    auto obj = objects.find(s);
    if (obj == objects.end()) {
        objects.insert({s, objects.size()});
        obj = objects.find(s);
    }

    return obj->second;
}

void DatalogParser::move_atom_to_head() {
    rule_head = get_current_atom();
}

void DatalogParser::move_atom_to_list() {
    rule_body.push_back(get_current_atom());
}

void DatalogParser::move_atom_to_i_state() {
    // TOOD: to_grounded inside common shared parent class for pddl/logic parsing
    i_state_list.push_back(to_grounded(get_current_atom()));
}

GroundAtom DatalogParser::to_grounded(Atom atom) {
    assert(!atom.is_negated());
    std::vector<ObjectRef> args;

    for (auto &arg : atom.get_args()) {
        assert(arg.is_object());
        args.push_back(arg.get_index());
    }

    return GroundAtom(atom.get_predicate(), args);
}

std::vector<ParameterOrObject> DatalogParser::get_current_args() {
    std::vector<ParameterOrObject> res;
    for (auto &arg : current_atom_args) {
        //TODO: is variable should be part of some common pddl parsing class
        bool is_var = is_variable(arg);
        ll index = is_var ? get_variable(arg) : get_object(arg);
        res.emplace_back(is_var, index); //TODO: this destroys the purpose of a variable token, can we get rid of it?
    }
    return res;
}

bool DatalogParser::is_variable(std::string &s) {
    return s.starts_with('?');
}

Atom DatalogParser::get_current_atom() {
    Atom at = Atom(get_predicate(current_atom_pred), get_current_args()); //TODO: rm all the evil copying
    if (!predicate_arity.contains(at.get_predicate())) {
        predicate_arity.insert({at.get_predicate(), at.get_args().size()});
    }
    current_atom_args.clear();
    return at;
}

void DatalogParser::move_rule_to_list() {
    rules.push_back(get_current_action());
    rule_body.clear();
    rule_vars.clear();
}

//TODO: should be part of shared data structure for indexing
std::vector<std::string> DatalogParser::to_vec(std::map<std::string, ll>& m) {
    std::vector<std::string> res(m.size());
    for (auto &entry : m) {
        res[entry.second] = entry.first;
    }
    return res;
};

Action DatalogParser::get_current_action() {
    return Action(
            "TODO: invent datalog rule names",
            to_vec(rule_vars),
            rule_body,
            {rule_head},
            {},
            current_cost
        );
}

void DatalogParser::build_task() {
    Predicates preds = get_current_predicates();
    std::vector<Atom> goal_atoms{{predicates.at(GOAL_PREDICATE), std::vector<ParameterOrObject>{}}};
    parser_repr = LiftedStripsTask(
            preds,
            get_current_objects(),
            rules,
            StripsState(i_state_list, preds.size()),
            goal_atoms
    );
}

Objects DatalogParser::get_current_objects() {
    Objects res;

    for (std::string &s : to_vec(objects)) {
        res.emplace_back(s);
    }

    return res;
}

Predicates DatalogParser::get_current_predicates() {
    Predicates res;

    ll i = 0;
    for (std::string &s : to_vec(predicates)) {
        res.emplace_back( s, predicate_arity[i]);
        i++;
    }

    return res;
}

}