#include "arg_parser.h"

#include <vector>
#include <cassert>

namespace HELP {

using namespace Lexer;

void ArgParser::parse() {
    check_and_consume(current_is(LBRACKET), "TODO"); //TODO msg

    while (!is_end()) {
        auto token = get_current();
        io_check(current_is_str_type(), "TODO"); //TODO msg
        auto str_token = std::static_pointer_cast<StringToken>(token);
        auto &key = str_token->get_string();
        consume();

        std::string val = "";
        if (current_is(EQUAL_SIGN)) {
            consume();
            auto second_str_token = std::static_pointer_cast<StringToken>(get_current()); //TODO: use consume bind instead
            val = second_str_token->get_string();
            consume();
        }

        io_check(almost_end() || current_is(COMMA) , "TODO was not unqiue"); //TODO: msg
        io_check(!almost_end() || current_is(RBRACKET), "TODO was not unqiue"); //TODO: msg
        io_check(!parser_repr.contains(key), "TODO"); //TODO: msg
        //TODO: check is valid key for --whatever
        parser_repr.insert({key, val});
        consume();
    }

    io_check(repr_searched(), "TODO didnt end yet", &**prev(lex_repr.end())); //TODO: errmsg
}

}