#include "token.h"

namespace HELP { 

namespace Lexer {

    std::unordered_set<char> special_id_starting_chars {
            '?',
            '_',
            '@'
    };

    std::unordered_set<char> special_id_chars {
            '-',
            '_',
            '@',
            '&',
            '%',
            '|',
            '!',
            '$'
    };

    std::unordered_set<char> special_id_seperator {
            ',',
            '(',
            ')',
            '=',
            '[',
            ']'
    };

    std::unordered_set<char> literal_start_end {
            '"',
            '\''
    };

    std::unordered_set<std::string> rule_type_col {
            "original",
            "join",
            "product",
            "project",
            "none"
    };

    std::unordered_map<TOKEN_TYPE, std::string> identifierable_m { // todo: is this needed or can we recycle char map?
            {EQUAL_SIGN, "="}
    };

    // currently [0..9]*, should support more, e.g. hexencoding
    bool is_valid_number_start(char c) {
        return isdigit(c);
    }

    // first char id
    bool valid_id_start(char c) {
        return isalpha(c) || special_id_starting_chars.contains(c);
    }

    // mid id
    bool valid_id_char(char c) {
        return isalpha(c) || isdigit(c) || special_id_chars.contains(c);
    }

    // id seperator
    bool valid_id_end(char c) {
        return isspace(c) || special_id_seperator.contains(c);
    }

    // string literal
    bool is_literal_start(char c) {
        return literal_start_end.contains(c);
    }

};

}
