#ifndef FAST_BACKWARD_LEXER_H
#define FAST_BACKWARD_LEXER_H

#include <vector>
#include <iostream>
#include "token.h"
#include "../input_handler.h"

namespace HELP { 

//TODO: note that paths have to be wrapped into ...

namespace Lexer {

class Lexer : public InputHandler {
    char current_c = 'a';
    TOKEN_TYPE current_t;
    std::stringstream current_str;
    TokenPosition current_pos{0,1};

    std::istream &instream;
    std::vector<std::shared_ptr<Token>> repr;

    void try_simple_token();
    void try_string_literal();
    void try_string_token();
    void try_number();
    void get_next_char();
    bool stream_empty();
    bool found_token();
    void reset_current();
    void create_next_token();
    void string_consume();
    void strict_next_char();
    bool stream_has_avail();

    void lex_check(bool cond, std::string msg, TokenPosition *tp=nullptr); //TODO: rather fail if?
    void lex_error(std::string msg, TokenPosition *tp=nullptr);

public:
    Lexer(std::istream &instream);

    void lex();
    void dump_repr(std::ostream &outs);
    std::vector<std::shared_ptr<Token>> &get_repr();
    std::vector<std::shared_ptr<Token>> &lex_and_get_repr(); //TODO: maybe call return lexer repr or something like that
};

}

}

#endif
