#include "lexer.h"
#include "../../logging/logger.h"

namespace HELP { 

namespace Lexer {

// TODO: err with position

void Lexer::get_next_char() {
    do {
        strict_next_char();
    } while (isspace(current_c) && !stream_empty());
}

// TODO: set Logger Mode
Lexer::Lexer(std::istream &instream) : instream(instream) {
    get_next_char();
}

void Lexer::try_simple_token() {
    switch (current_c) {
        case '.': {
            current_t = DOT;
            break;
        }
        case '=': {
            current_t = EQUAL_SIGN;
            break;
        }
        case ',': {
            current_t = COMMA;
            break;
        }
        case '[': {
            current_t = LBRACKET;
            break;
        }
        case ']': {
            current_t = RBRACKET;
            break;
        }
        case '(': {
            current_t = LPAREN;
            break;
        }
        case ')': {
            current_t = RPAREN;
            break;
        }
        case ':': {
            strict_next_char();
            if (current_c == '-') {
                current_t = DL_RULE_SPECIFIER;
            } else {
                lex_error("colon followed by TODO"); //TODO err msg
            }
            break;
        }
    }

    if (current_t != NO_TOKEN) {
        get_next_char();
    }
}

void Lexer::string_consume() {
    current_str << current_c;
    strict_next_char();
}

void Lexer::try_number() {
    if (is_valid_number_start(current_c)) {
        string_consume(); //TODO: wouldn't wrk with hex, bytes, whatever identifier

        while (!stream_empty() && isdigit(current_c)) {
            string_consume();
        }

        //TODO: is this the right check?
        lex_check(!valid_id_end(current_c), "TODO"); //TODO: err msg, should prob not be part of lexer, but parser

        while (isspace(current_c)) { //TODO: appropriate or should this use something else?
            get_next_char();
        }

        current_t = NUMBER;
    }
}

void Lexer::try_string_token() {
    if (valid_id_start(current_c)) {
        string_consume();

        while (!stream_empty() && valid_id_char(current_c)) {
            string_consume();
        }

        lex_check(!valid_id_end(current_c), "TODO"); //TODO: err msg, should prob not be part of lexer, but parser

        while (isspace(current_c)) { //TODO: appropriate or should this use something else?
            get_next_char();
        }

        current_t = SOME_STR;
    }
}

void Lexer::try_string_literal() { //TODO: could probably combine try_string_literal, try_string_token, try_number
    if (is_literal_start(current_c)) {
        char start_is = current_c;
        string_consume();

        while (!stream_empty() && start_is != current_c) {
            string_consume();
        }

        lex_check(start_is != current_c, "TODO"); //TODO: err msg

        string_consume();

        while (isspace(current_c)) { //TODO: appropriate or should this use something else?
            get_next_char();
        }

        current_t = STRING_LITERAL;
    }
}

bool Lexer::stream_empty() {
    return current_c == '\0';
}

bool Lexer::found_token() {
    return current_t != NO_TOKEN;
}

void Lexer::reset_current() {
    current_t = NO_TOKEN;
    current_str.str("");
    current_str.clear();
}

void Lexer::lex() {
    while (!stream_empty()) {
        reset_current();

        try_simple_token();

        if (!found_token()) {
            try_number();
        }
        if (!found_token()) {
            try_string_literal();
        }
        if (!found_token()) {
            try_string_token();
        }
        lex_check(!found_token(), "TODO"); //TODO: err msg

        create_next_token();
    }
}

void Lexer::create_next_token() {
    assert(found_token());
    repr.push_back(create_token(current_t, current_str, current_pos));
}

void Lexer::dump_repr(std::ostream &outs) {
    if (!repr.empty()) {
        int old_y = (*repr.begin())->get_position().y;
        for (auto token: repr) {
            outs << *token << " ";
            int new_y = token->get_position().y;
            if (old_y < new_y) {
                old_y = new_y;
                outs << std::endl;
            }
        }
    } else {
        outs << "(empty)";
    }
    outs << std::endl;
}

std::vector<std::shared_ptr<Token>> &Lexer::get_repr() {
    return repr;
}

std::vector<std::shared_ptr<Token>> &Lexer::lex_and_get_repr() {
    lex();
    return get_repr();
}

bool Lexer::stream_has_avail() {
    return instream.peek() != EOF; //TODO: it should be easy to simply strict next char this way
}

void Lexer::strict_next_char() {
    if (!stream_has_avail()) {
        current_c = '\0';
    } else {
        if (current_c == '\n' || current_c == '\r') {
            if (current_c == '\r' && instream.peek() == '\n') {
                current_c = instream.get(); //TODO: is there just pop?
                if (!stream_has_avail()) {
                    current_c = '\0';
                    return;
                }
            }
            current_pos.x = 1;
            current_pos.y++;
        } else {
            current_pos.x++;
        }

        current_c = instream.get();
    }
}

void Lexer::lex_check(bool cond, std::string msg, TokenPosition *tp) {
    if (!tp) {
        tp = &current_pos;
    }

    io_check(cond, msg, *tp);
}

void Lexer::lex_error(std::string msg, TokenPosition *tp) {
    if (!tp) {
        tp = &current_pos;
    }

    io_error(msg, *tp);
}

}

}