#ifndef FAST_BACKWARD_INPUT_HANDLER_H
#define FAST_BACKWARD_INPUT_HANDLER_H

#include <vector>
#include "lexer/token.h"
#include "../logging/logger.h"

namespace HELP { 

class PositionStringBuilder : public StringBuilder {
    std::string name;
    Lexer::TokenPosition p;

public:
    PositionStringBuilder(std::string name, Lexer::TokenPosition p); //TODO important: will always copy string, make sure overhead is negligible -- could probabaly just use macro for error_if
    virtual std::string build_str() override; //TODO: descr for logger
};

class InputHandler {
protected:
    void io_check(bool b, std::string msg, Lexer::TokenPosition &p); //TODO: io -> input
    void io_error(std::string msg, Lexer::TokenPosition &p); //TODO: io -> input

    std::string get_unit_name() { return "TODO"; } // TODO -- Lexer/Parser return
    std::vector<std::shared_ptr<StringBuilder>> get_str_builder(std::string msg, Lexer::TokenPosition &p);
public:
    virtual ~InputHandler() = default;
};

}

#endif