#include "input_handler.h"
#include "../logging/logger.h"

#include <iostream>

namespace HELP { 

void InputHandler::io_check(bool b, std::string msg, Lexer::TokenPosition &p) { //TODO: rename to error if
    Logger::error_if(b, get_str_builder(msg, p));
}

void InputHandler::io_error(std::string msg, Lexer::TokenPosition &p) {
    Logger::error(get_str_builder(msg, p));
}

std::vector<std::shared_ptr<StringBuilder>> InputHandler::get_str_builder(std::string msg, Lexer::TokenPosition &p) {
    return {
        make_shared<PositionStringBuilder>(get_unit_name(), p),
        make_shared<TrivialStringBuilder>(msg)
    };
}

PositionStringBuilder::PositionStringBuilder(std::string name, Lexer::TokenPosition p) : name(name), p(p) { }

std::string PositionStringBuilder::build_str() {
    return name + " (" + std::to_string(p.x) + ", " + std::to_string(p.y) + "):";
}

}