#ifndef HELP_CORE_TABLE_CACHE_H
#define HELP_CORE_TABLE_CACHE_H

#include "table.h"
#include "../../utils/type_defs.h"
#include "../../task_formulations/db_propositional_shared.h"
#include "../join_realizer/init_nodes.h"

#include <queue>

namespace HELP { 

namespace QueryEval {
    template<typename T>
    struct AutoResetVecInit;

    template<>
    struct AutoResetVecInit<JoinTable::Table> {
        static inline JoinTable::Table init_field = {};
    };

    template<typename T>
    struct AutoResetVecInit<std::vector<T>> {
        static inline std::vector<T> init_field = {};
    };

    //TODO: combine num types

    template<>
    struct AutoResetVecInit<ll> {
        static inline ll init_field = 0;
    };

    template<>
    struct AutoResetVecInit<char> {
        static inline char init_field = 0;
    };

    template<>
    struct AutoResetVecInit<bool> {
        static inline bool init_field = false;
    };

    template<typename T>
    class AutoResetVec { //TODO: make util for arbitrary collection
        unsigned long long &timestamp;
        std::vector<bool> no_reset;
        std::vector<unsigned long long> element_time_stamp; // todo rename
        std::vector<T> elements;

    public:
        AutoResetVec(unsigned long long &timestamp, size_t size) : timestamp(timestamp) {
            extend(size);
        }

        void extend(size_t size) {
            no_reset.resize(size, false);
            element_time_stamp.resize(size, timestamp);
            elements.resize(size, AutoResetVecInit<T>::init_field);
        }

        void mark_no_reset(size_t id) {
            no_reset[id] = true;
        }

        T &at(size_t pos) {
            assert(pos < elements.size());
            if (element_time_stamp[pos] != timestamp) {
                if (!no_reset[pos]) {
                    elements[pos] = AutoResetVecInit<T>::init_field;
                }
                element_time_stamp[pos] = timestamp;
            }
            return elements.at(pos);
        }

        auto size() const {
            return elements.size();
        }
    };

    class TableCache {
        unsigned long long timestamp = 0;  //TODO: move to parent

        AutoResetVec<JoinTable::Table> tables;
        AutoResetVec<ll> pre_f;
    public:
        TableCache(ll table_am, ll pred_am);
        TableCache() : TableCache(0,0) {}

        JoinTable::Table &get_node_table(ll t_at); //TODO: make types arr node id
        void reset();
        void extend(ll size);

        auto &get_pre_f() {
            return pre_f;
        }

        void register_node(NodeId id, JoinGraphNode &node, NodeLookup *node_lookup);

        void adjust_pre_f_edge(NodeId from, NodeId to, HELP::QueryEval::NodeType from_type, NodeLookup *node_lookup, bool further_increase_allowed);
    };

    class DeltaTableCache {
        TableCache accumulated_tables;
        TableCache current_delta;

    public:
        DeltaTableCache(ll table_am, ll pred_am) : accumulated_tables(table_am, pred_am), current_delta(table_am, pred_am) {}

        auto &get_accumulated_tables() {
            return accumulated_tables;
        }
    };

}

}


#endif //HELP_CORE_TABLE_CACHE_H
