#include "table_cache.h"
#include <unordered_set>

namespace HELP { 

//TODO: rather evaluation cache? (and move to join realizer?)

namespace QueryEval {
    TableCache::TableCache(ll table_am, ll pred_am) : tables(timestamp, table_am), //TODO: remove pred_am
                                                      pre_f(timestamp, table_am)
                                                      { }

    JoinTable::Table &TableCache::get_node_table(ll t_at) {
        return tables.at(t_at);
    }

    void TableCache::reset() {
        timestamp++;
    }

    void TableCache::extend(ll size) {
        assert(tables.size() <= size);
        assert(pre_f.size() <= size);

        tables.extend(size);
        pre_f.extend(size);
    }

    void TableCache::register_node(NodeId id, JoinGraphNode &node, NodeLookup *node_lookup) {
        if (node.is_static) {
            tables.mark_no_reset(node.arr_id);
            pre_f.mark_no_reset(node.arr_id);
        }
    }

    void TableCache::adjust_pre_f_edge(HELP::QueryEval::NodeId from, HELP::QueryEval::NodeId to, HELP::QueryEval::NodeType from_type, NodeLookup *node_lookup, bool further_increase_allowed) {
        if (!to.is_merge())
            return;

        if ((from_type == REORDER && pre_f.at(node_lookup->arr_get(from)) == 1)
            || (from_type == MERGE && pre_f.at(node_lookup->arr_get(from)) == 2)) {

            auto &cont = pre_f.at(node_lookup->arr_get(to));
            if (!cont || further_increase_allowed) {
                cont++;
            }
        }
    }
}

}