#ifndef HELP_CORE_GEN_DB_TABLE_H
#define HELP_CORE_GEN_DB_TABLE_H

#include <set>
#include <vector>
#include "../../utils/type_defs.h"
#include "../join_realizer/nodes.h"

namespace HELP { 

namespace QueryEval {
    namespace JoinTable {

    typedef std::vector<ll> Row;
    typedef std::set<Row> Table;

    inline bool compares_eq(const Row &left, const Row &right, const std::vector<PositionMerge> &positions) {
        for (auto &pos : positions) {
            if (left[pos.from_left] != right[pos.from_right]) {
                return false;
            }
        }
        return true;
    }

    inline bool compares_less(const Row &left, const Row &right, const std::vector<PositionMerge> &positions) {
        for (auto &pos : positions) {
            if (left[pos.from_left] < right[pos.from_right]) {
                return true;
            } else if (left[pos.from_left] > right[pos.from_right]) {
                return false;
            }
        }
        return false;
    }

    inline void reorder(Table &from, Table &to, std::vector<PositionForward> &re_order) {
        for (auto &row : from) {
            Row next_row(re_order.size());
            assert(row.size() >= re_order.size());
            for (auto &order_el : re_order) { //TODO: maybe just make this one vec at some point
                next_row[order_el.to] = row[order_el.from];
            }
            to.insert(next_row);
        }
    }

    inline void merge(Table &left, Table &right, Table &to, std::vector<PositionMerge> &join_rules,
                                std::vector<PositionForward> &left_forward, std::vector<PositionForward> &right_forward) {
        assert(left.empty() || left.begin()->size() >= join_rules.size()+left_forward.size());
        assert(right.empty() || right.begin()->size() >= join_rules.size()+right_forward.size());

        auto i = left.begin();
        auto j = right.begin();
        while (i != left.end() && j != right.end()) {
            if (compares_eq(*i, *j, join_rules)) {
                const Row& ref = *i;
                std::vector<const Row*> left_rows; //TODO: wrap in function
                while (i != left.end() && compares_eq(*i, ref, join_rules)) {
                    left_rows.push_back(&*i);
                    i++;
                }

                std::vector<const Row*> right_rows; //TODO: wrap in function
                while (j != right.end() && compares_eq(*j, ref, join_rules)) {
                    right_rows.push_back(&*j);
                    j++;
                }

                for (auto *_row_l : left_rows) {
                    for (auto *_row_r : right_rows) { //TODO: important TODO important potentially creates far too many duplicated entries
                        auto &row_l = *_row_l;
                        auto &row_r = *_row_r;
                        Row res(join_rules.size() + left_forward.size() + right_forward.size()); //TODO: wrap in func similar to merge node size
                        for (auto &merge_info : join_rules) { //TODO: wrap in function //TODO: to outer loop
                            assert(row_l[merge_info.from_left] == row_r[merge_info.from_right]);
                            res[merge_info.to] = row_l[merge_info.from_left];
                        }
                        for (auto &forward_info : left_forward) { //TODO: wrap in function //TODO: to outer loop
                            res[forward_info.to] = row_l[forward_info.from];
                        }
                        for (auto &forward_info : right_forward) { //TODO: wrap in function
                            res[forward_info.to] = row_r[forward_info.from];
                        }
                        to.insert(to.end(), res); //TODO take short cut if res is empty
                    }
                }
            } else if (compares_less(*i, *j, join_rules)) {
                ++i; //TODO: important TODO important - should check if lowerbound may be more attractive in some cases
            } else {
                ++j; //TODO: important TODO important - should check if lowerbound may be more attractive in some cases
            }
        }
    }

    //TODO: can we combine this with normal merge?
    inline void r_negated_merge(Table &left, Table &right, Table &to, std::vector<PositionMerge> &join_rules,
                      std::vector<PositionForward> &left_forward, std::vector<PositionForward> &right_forward) {

        auto i = left.begin();
        auto j = right.begin();
        while (i != left.end() && j != right.end()) {
            if (compares_less(*i, *j, join_rules)) {
                auto &row_l = *i;

                Row res(join_rules.size() + left_forward.size() + right_forward.size()); //TODO: wrap in func similar to merge node size
                for (auto &merge_info : join_rules) { //TODO: wrap in function //TODO: to outer loop
                    res[merge_info.to] = row_l[merge_info.from_left];
                }
                for (auto &forward_info : left_forward) { //TODO: wrap in function //TODO: to outer loop
                    res[forward_info.to] = row_l[forward_info.from];
                }

                to.insert(to.end(), res); //TODO take short cut if res is empty

                ++i; //TODO: important TODO important - should check if lowerbound may be more attractive in some cases
            } else if (compares_less(*j, *i, join_rules)) {
                ++j; //TODO: important TODO important - should check if lowerbound may be more attractive in some cases
            } else {
                assert(compares_eq(*i, *j, join_rules));
                ++i; //TODO: important TODO important - should check if lowerbound may be more attractive in some cases
            }
        }
    }

    }
}

}

#endif //HELP_CORE_GEN_DB_TABLE_H
