#include "start_node_manager.h"

namespace HELP { 

namespace QueryEval {

    template <bool consider_static>
    bool RegressiveStartNodeManger<consider_static>::set_used(ll id) {
        if (!used.at(id)) {
            if (is_start_node(id)) {
                auto &r_data = reg_data[id];
                current_start_nodes.register_node(r_data.predicate, r_data.id);
            }

            used.at(id) = true;
            assert(!just_used.at(id));
            just_used.at(id) = true;
            return true;
        } else {
            return false;
        }
    }

    template <bool consider_static>
    void RegressiveStartNodeManger<consider_static>::register_predecessor(NodeId to, NodeId from, NodeLookup *node_lookup) {
        current_edges.at(node_lookup->arr_get(from)).push_back(to);
    }

    template <bool consider_static>
    void RegressiveStartNodeManger<consider_static>::register_node(NodeId id, JoinGraphNode &node, NodeLookup *node_lookup) {
        if (node.is_static) {
            used.mark_no_reset(node.arr_id);
        }
        if (id.is_init()) {
            reg_data.emplace(node.arr_id, RegDataEntry{static_cast<InitNode&>(node).initializer->predicate, id});
        }
    }

    template <bool consider_static>
    void RegressiveStartNodeManger<consider_static>::extend(size_t new_size) {
        used.extend(new_size);
        just_used.extend(new_size);
        current_edges.extend(new_size);
    }

    template <bool consider_static>
    bool RegressiveStartNodeManger<consider_static>::should_visit(ll id) {
        return used.at(id);
    }
}

}
