#ifndef HELP_CORE_JOIN_ORDER_GRAPH_TPP
#define HELP_CORE_JOIN_ORDER_GRAPH_TPP

#include "join_order_graph.h"
#include <queue>
#include <vector>

namespace HELP { 

namespace QueryEval {

// TODO: make sure not to generate duplicates
template<typename t>
void JoinOrderGraph::evaluate(t &init_info, TableCache &cache, StartNodeManager &start_node_manager,
                                  DBInfo &db_info, std::vector<NodeId> *last_nodes,
                                  std::unordered_set<NodeId> *increased) { //TODO: early stopping if empty
    std::queue<NodeId> q; //TODO: this should be a simple queue
    auto &pre_f = cache.get_pre_f();

    auto &additional_start_nodes = start_node_manager.get_additional_start_nodes();
    for (NodeId id : additional_start_nodes) {
        adjust_pre_f(cache, id, q);
    }
    additional_start_nodes.clear(); //TODO important: is this really generally expected behavior?

    start_node_manager.collect_start_nodes(init_info, q); //TODO: directly push to q

    std::unordered_set<NodeId> seen;
    std::unordered_set<NodeId> predecessor;

    while (!q.empty()) {
        auto node_id = q.front();
        if (last_nodes) seen.insert(node_id);
        q.pop();
        auto &_node = get(node_id);

        if (!start_node_manager.should_visit(_node.arr_id)) {
            continue;
        }

        if (node_id.is_init()) { //TODO: make this a visitor
            auto &node = static_cast<InitNode &>(_node);
            node.initializer->init(cache.get_node_table(node.arr_id), init_info, db_info);
        } else if (node_id.is_merge()) {
            auto &node = static_cast<MergeNode &>(_node);
            assert(pre_f.at(node.arr_id) == 2);
            if (last_nodes) predecessor.insert(node.left);
            if (last_nodes) predecessor.insert(node.right);
            merge(node, cache);
        } else {
            assert(node_id.is_reorder());
            auto &node = static_cast<ReOrderNode &>(_node);
            assert(pre_f.at(node.arr_id) == 1);
            if (last_nodes) predecessor.insert(node.from);
            reorder(node, cache);
        }

        if (!cache.get_node_table(_node.arr_id).empty()) {
            for (NodeId to_id: start_node_manager.get_relevant_node_edges(_node)) {
                if (increased) increased->insert(to_id);
                auto &to = get(to_id);

                if (++pre_f.at(to.arr_id) == 2 || to_id.is_reorder()) {
                    assert(to_id.is_reorder() || pre_f.at(to.arr_id) == 2 && "is merge but pre_f is != 2");
                    assert(to_id.is_merge() || pre_f.at(to.arr_id) == 1 && "is reorder but pre_f is != 1");
                    q.push(to_id);
                } else {
#ifndef NDEBUG
                    // static parts were merged first, pre_f adjusted accordingly
                    if (to_id.is_merge()) {
                        auto &mnode = static_cast<MergeNode &>(get(to_id));
                        NodeId other = mnode.left == node_id ? mnode.right : mnode.left;
                        if (get(other).is_static && start_node_manager.does_consider_static()) {
                            assert(cache.get_node_table(get(other).arr_id).empty()
                                   || _node.is_static
                                   && "pre_f was not increased for static, non-empty join of 'other'");
                        }
                    }
#endif
                }
            }
            start_node_manager.reset_relevant_node_edges(_node);
        }
    }

    if (last_nodes) {
        for (NodeId p : predecessor) {
            seen.erase(p);
        }
        for (NodeId s : seen) {
            last_nodes->push_back(s);
        }
    }
}

template<bool use_static>
void JoinOrderGraph::mark_for_exploration(NodeId id, RegressiveStartNodeManger<use_static> &manger) {
    auto &node = get(id);
    if (manger.set_used(node.arr_id)) {
        if (id.is_init()) { // TODO: make visitor
        } else if (id.is_merge()) {
            auto &merge_node = static_cast<MergeNode&>(node);
            manger.register_predecessor(id, merge_node.left, this);
            manger.register_predecessor(id, merge_node.right, this);

            int explore_count = manger.was_explore_marked(get(merge_node.left).arr_id) + manger.was_explore_marked(get(merge_node.right).arr_id);

            if (explore_count) {
                manger.register_additional_start_node(id);
            }

            if (explore_count < 2) {
                mark_for_exploration(merge_node.left, manger);
                mark_for_exploration(merge_node.right, manger);
            }
        } else if (id.is_reorder()) {
            auto &reorder_node = static_cast<ReOrderNode&>(node);
            manger.register_predecessor(id, reorder_node.from, this);

            if (manger.was_explore_marked(get(reorder_node.from).arr_id)) {
                manger.register_additional_start_node(id);
            } else {
                mark_for_exploration(reorder_node.from, manger);
            }
        } else {
            assert(false && "shouldn't happen");
        }
    }
}

}

}

#endif //HELP_CORE_JOIN_ORDER_GRAPH_TPP
