#include "join_order_graph.h"
#include "../join_order_generator/join_order_generator.h"
#include "magic_enum.hpp"
#include <queue>
#include <algorithm>
#include <unordered_set>

namespace HELP { 

// TODO: remove unused functions
// TODO: enabler strategy: if join becomes empty mark other side of edges joined into as no explore now

// #define JOG_DEBUG_FLAG_PRINT_HEAD_MATCH_AMOUNT // print amount of head nodes matched in add new query
// #define JOG_DEBUG_FLAG_PRINT_MATCHES_FOUND // print amount of head nodes matched in add new query
// #define JOG_DEBUG_FLAG_PRINT_TRY_MATCH_RESULTS // print query mapping results
// #define JOG_DEBUG_FLAG_PRINT_FAIL_EXTRACTION_INIT // print init nodes reached with fail flag != -1 during fail extraction
// #define DEBUG_FLAG_PRINT_REORDER_CACHE_HIT // print cache hit for reorder builds
// #define JOG_DEBUG_FLAG_PRINT_NODE_CACHE_HIT_TYPE // on cache hit print which node type was hit
// #define JOG_DEBUG_FLAG_PRINT_NODE_CACHE_HIT_TYPE_NO_PRED // disable JOG_DEBUG_FLAG_PRINT_NODE_CACHE_HIT_TYPE fro predicates
// #define JOG_DEBUG_FLAG_PRINT_BUILD_PROCESS // prints currently building + query
// #define JOG_DEBUG_FLAG_PRINT_BUILD_PROCESS_JO // + annotated join order
// #define JOG_DEBUG_FLAG_PRINT_BUILD_PROCESS_NODE_CREATION // prints nodes created per join element
// #define JOG_DEBUG_FLAG_PRINT_TRY_MATCH_RESULTS_PRINTREPR // print repr + var mapping
// #define JOG_DEBUG_FLAG_PRINT_EARS // print ears for multiple hash join computation

namespace QueryEval {

    static DBInfo NO_INFO;
    using namespace std;
    using namespace JoinTable;
    static bool enable_semantic_query_match = false; //TODO: make this an actual option
    static bool enable_syntactic_query_match = false; //TODO: make this an actual option
    static bool enable_syntactic_query_match_for_jo = true && enable_syntactic_query_match; //TODO: make this an actual option
    static ll MATCH_BOUND_FACTOR = 10; // one order of magintude
    static GroundAtomCol EMPTY_STATE;

    JoinOrderGraph::JoinOrderGraph(Query &query, AnnotatedJoinOrder &join_order, DBInfo &info) : JoinOrderGraph(info) { //TODO (important): create without result pars in mind, then extend forward path to full reducer per result pars
        build_simple(query, join_order, info);
        //TODO: important TODO important remove useless reorder nodes in join graph
    }

    static void print_init_collection(InitCollection &init_collection) {
        ll e = 0;
        for (auto &[p, v] : init_collection.predicate_init) {
            ll c = 0;
            for (auto &entry : v) {
                std::cout << char('A' + p) << "(";
                ll d = 0;
                for (auto &var : entry) {
                    std::cout << "?" << var;
                    if (++d != entry.size()) std::cout << ", ";
                }
                std::cout << ")";
                if (++c != v.size()) std::cout << ", ";
            }
            if (++e != init_collection.predicate_init.size()) std::cout << ", ";
        }
    }

    void print_query_el(Atom &atom) {
        std::cout << char('A'+atom.get_predicate()) << "(";

        auto &entry = atom.get_args();
        ll d = 0;
        for (auto &var : entry) {
            assert(var.is_variable());
            std::cout << "?" << var.get_index();
            if (++d != entry.size()) std::cout << ", ";
        }
        std::cout << ")";
    }

    void print_pars(std::vector<ParRef> &pars) {
        ll d = 0;
        for (auto par : pars) {
            cout << "?" << par;
            if (++d != pars.size()) cout << ", ";
        }
    }

    void JoinOrderGraph::init_if_needed(Query &query, ll id, vector<NodeId> &current_node_map,
                                        vector<std::unordered_map<ll, ll>> &current_var_to_pos_map,
                                        std::map<ll, NodeId> *predicate_node_map, DBInfo &info) {
        if (current_node_map[id] == NO_NODE) { //TODO: combine with below
            auto p = query.get_atom(id).get_predicate();
            if (p >= 0) { //TODO: proper handling
                std::vector<ll> reorder;
                current_node_map[id] = build_initialize(query.get_atom(id), reorder, info);
                auto &args = query.get_atom(id).get_args();
                assert(args.size() == reorder.size());
                for (ll i = 0; i < args.size(); i++) {
                    auto &arg = args[i];
                    assert(arg.is_variable());
                    current_var_to_pos_map[id].emplace(arg.get_index(), reorder[i]);
                }
            } else {
                assert(predicate_node_map && predicate_node_map->contains(p));
                current_node_map[id] = predicate_node_map->at(p);
                auto &args = query.get_atom(id).get_args(); //TODO: combine with reorder version above
                for (ll i = 0; i < args.size(); i++) {
                    auto &arg = args[i];
                    assert(arg.is_variable());
                    current_var_to_pos_map[id].emplace(arg.get_index(), i);
                }
            }
        }
    }

    static void adjust_var_to_pos(std::unordered_map<ll, ll> &var_to_pos, std::unordered_map<ll, ll> &re_reorder) {
        std::unordered_map<ll, ll> new_var_to_pos;
        for (auto &[var, pos] : var_to_pos) {
            assert(re_reorder.contains(pos));
            new_var_to_pos.emplace(var, re_reorder.at(pos));
        }
        var_to_pos = new_var_to_pos;
    }

    static void normalize_pfw_to(std::vector<PositionForward> &pfw, std::unordered_map<ll, ll> &to_reorder) {
        if (pfw.empty())
            return;

        ll min_val = pfw.begin()->to;
        for (auto &[from, to] : pfw) {
            min_val = min(min_val, to);
        }

#ifndef NDEBUG
        // validate range
        std::unordered_set<ll> range;
        for (auto &[from, to] : pfw) {
            assert(min_val <= to && to < min_val+pfw.size());
            range.insert(to);
        }
        assert(range.size() == pfw.size());
#endif

        std::sort(pfw.begin(), pfw.end(), [](const PositionForward &l, const PositionForward &r){
            if (l.from < r.from) {
                return true;
            } else if (l.from > r.from) {
                return false;
            }

            return l.to < r.to;
        });
        for (auto &pfw_el : pfw) {
            to_reorder.emplace(pfw_el.to, min_val);
            pfw_el.to = min_val++;
        }
    }

    static void adjust_pfw(std::vector<PositionForward> &pfw, std::unordered_map<ll, ll> &re_reorder, std::unordered_map<ll, ll> &to_reorder) {
        std::vector<PositionForward> new_pfw;
        for (auto &[from, to] : pfw) {
            assert(re_reorder.contains(from));
            new_pfw.push_back({re_reorder.at(from), to});
        }
        pfw = new_pfw;
        normalize_pfw_to(pfw, to_reorder);
    }

    bool JoinOrderGraph::to_has_from(NodeId from, NodeId to) {
        if (to.is_init()) {
            return false;
        } else if (to.is_reorder()) {
            return static_cast<ReOrderNode&>(get(to)).from == from;
        } else {
            assert(to.is_merge());
            return static_cast<MergeNode&>(get(to)).left == from || static_cast<MergeNode&>(get(to)).right == from;
        }
    }

    bool JoinOrderGraph::build_simple_process_je_element(vector<NodeId> &current_node, vector<std::unordered_map<ll, ll>> &current_var_to_pos, const AnnotatedJoinOrderElement &join, bool try_match_only) {
        // creates JOG node for JO element
        // if try match only is activated it does this only if it can match the existing nodes
        ll from = join.element.from_id;
        ll to = join.element.to_id;
        assert(from != to);

        std::unordered_map<ll, ll> new_var_to_pos;
        auto res = build_join_by_rule(current_node[from], current_node[to],
                                              current_var_to_pos[from], current_var_to_pos[to], join, new_var_to_pos, try_match_only);
        if (res != NO_NODE) {
            current_node[to] = res;
            current_var_to_pos[to] = new_var_to_pos;
            assert(current_var_to_pos.at(to).size() == get_pos_size(current_node.at(to)));
            return true;
        }

        return false;
    }

    static void print_node(NodeId id) {
        cout << "{ type: " << magic_enum::enum_name(id.get_enum_val()) << ", id_num: " << id.id_num << " }";
    }

    static void determine_ears(std::unordered_set<ll> &ears, const std::vector<ParRef> &common_pars, std::set<ll> &je_exists, vector<const AnnotatedJoinOrderElement *> &delayed_elements, vector<std::unordered_map<ll, ll>> &current_var_to_pos) {
        // ban result pars
        std::unordered_set<ll> removed;
        for (auto var : common_pars) {
            removed.insert(var);
        }

        // insert only once (= all vars occuring exactly in one atom)
        for (auto i : je_exists) {
            for (auto &[var, pos] : current_var_to_pos.at(delayed_elements.at(i)->element.from_id)) {
                if (ears.contains(var)) {
                    removed.insert(var);
                    ears.erase(var);
                } else if (!removed.contains(var)) {
                    ears.insert(var);
                }
            }
        }
    }

    static void determine_normalized_var_map(std::unordered_map<ll, ll> &normalized_var_map, std::set<ll> &je_exists, vector<const AnnotatedJoinOrderElement *> &delayed_elements, vector<std::unordered_map<ll, ll>> &current_var_to_pos, ll common_to) {
        for (auto &[var, pos] : current_var_to_pos.at(common_to)) {
            normalized_var_map.emplace(var, pos);
        }

        for (auto rit = je_exists.rbegin(); rit != je_exists.rend(); ++rit) {
            auto i = *rit;
            for (auto &[var, _] : current_var_to_pos.at(delayed_elements.at(i)->element.from_id)) {
                if (!normalized_var_map.contains(var)) {
                    normalized_var_map.emplace(var, normalized_var_map.size());
                }
            }
        }
    }

    bool JoinOrderGraph::try_match_all_to(ll common_to, const std::vector<ParRef> &common_pars, std::set<ll> &je_exists, vector<const AnnotatedJoinOrderElement *> &delayed_elements, vector<NodeId> &current_nodes, vector<std::unordered_map<ll, ll>> &current_var_to_pos, MultipleJoinMatchHash &h, std::unordered_map<ll,ll> &first_from_pos_to_var) {
        auto to_node = current_nodes[common_to];
        assert(to_node != NO_NODE);

        //TODO: it would make more sense to adjust this dynamically instead of recomputing again and again, for now given the assumption of small waiting containers, this should be fine
        std::vector<std::pair<NodeId, std::vector<std::pair<ll, ll>>>> from_identification;
        std::unordered_set<ll> ears; // variables occuring in only one atom and not in the result //TODO important: could use ears for variable mapping already
        determine_ears(ears, common_pars, je_exists, delayed_elements, current_var_to_pos);
#ifdef JOG_DEBUG_FLAG_PRINT_EARS
        std::cout << "ears are: ";
        ll i = 0;
        for (auto ear : ears) {
            std::cout << "?" << ear;
            if (++i != ears.size()) std::cout << ", ";
        }
        if (ears.empty()) {
            std::cout << "(empty)";
        }
        std::cout << std::endl;
#endif
        std::unordered_map<ll, ll> normalized_var_map;
        determine_normalized_var_map(normalized_var_map, je_exists, delayed_elements, current_var_to_pos, common_to);

        for (auto i : je_exists) {
            auto pos = delayed_elements.at(i)->element.from_id;
            auto &var_to_pos = current_var_to_pos.at(pos);
            std::vector<std::pair<ll, ll>> relevant_var_to_pos;
            for (auto &[var, pos] : current_var_to_pos.at(pos)) {
                if (!ears.contains(var)) { // pars_tracked contained in from node
                    assert(normalized_var_map.contains(var));
                    relevant_var_to_pos.emplace_back(normalized_var_map.at(var), pos);
                }
            }
            std::sort(relevant_var_to_pos.begin(), relevant_var_to_pos.end()); // normalize
            from_identification.emplace_back(current_nodes.at(pos), relevant_var_to_pos);
        }

        std::sort(from_identification.begin(), from_identification.end()); // normalize
        auto &first_from_element_mapping = from_identification.begin()->second;
        std::unordered_map<ll,ll> normalized_var_to_pos(first_from_element_mapping.begin(), first_from_element_mapping.end());
        for (auto &[original_var, normalized_var] : normalized_var_map) {
            if (normalized_var_to_pos.contains(normalized_var)) {
                first_from_pos_to_var.emplace(normalized_var_to_pos.at(normalized_var), original_var);
            }
        }

        h = MultipleJoinMatchHash{to_node, from_identification};
        if (multiple_join_matches.contains(h)) {
#ifdef JOG_DEBUG_FLAG_PRINT_TRY_MATCH_RESULTS
            std::cout << "Match in try optimize build: ";
            ll l = 0;
            for (auto i : je_exists) {
                std::cout << delayed_elements.at(i)->element.from_id;
                if (++l != je_exists.size()) std::cout << ", ";
            }
            std::cout << " -> " << common_to;
            std::cout << " via hash {";
            print_node(h.to);
            std::cout << ", ";
            for (auto &el : h.froms) {
                print_node(el.first);
                l = 0;
                std::cout << "{";
                for (auto &p : el.second) {
                    std::cout << "(" << p.first << ", " << p.second << ")";
                    if (++l != el.second.size()) std::cout << ", ";
                }
                std::cout << "}";
            }
            std::cout << "}";
            cout << endl;
#endif

            auto &[matched, to_remapping, excess_from_remapping] = multiple_join_matches.at(h);
            current_nodes[common_to] = matched;

            auto &to_remap = current_var_to_pos.at(common_to);
            assert(get_pos_size(matched) == common_pars.size());

            std::unordered_map<ll, ll> adjusted_map;
            for (auto &[var, pos] : to_remap) {
                assert(to_remapping.contains(pos));
                adjusted_map.emplace(var, to_remapping.at(pos));
            }

            for (auto &[pos, var] : first_from_pos_to_var) {
                if (excess_from_remapping.contains(pos)) {
#ifndef NDEBUG
                    auto cppos = excess_from_remapping.at(pos);
                    assert(!adjusted_map.contains(var));
                    assert(std::find_if(adjusted_map.begin(), adjusted_map.end(), [cppos](const std::pair<ll,ll>& el){
                        return el.second == cppos;
                    }) == adjusted_map.end());
#endif
                    adjusted_map.emplace(var, excess_from_remapping.at(pos));
                }
            }

            to_remap = adjusted_map;
            assert(to_remap.size() == get_pos_size(matched));

#ifdef JOG_DEBUG_FLAG_PRINT_TRY_MATCH_RESULTS_PRINTREPR
            std::cout << "Single query representation for match is: ";
            InitCollection atoms_underlying;
            std::vector<ll> ignore;
            collect_atoms(atoms_underlying, QueryEval::NO_NODE, ignore, &matched);
            print_init_collection(atoms_underlying);
            std::cout << std::endl;

            std::cout << "With according var representation: ";
            ll x = 0;
            for (auto &[var, pos] : current_var_to_pos.at(common_to)) {
                std::cout << "?" << var << " -> " << pos;
                if (++x != current_var_to_pos.at(common_to).size()) std::cout << ", ";
            }
            std::cout << std::endl;

            std::cout << "Normalization for this was: ";
            x = 0;
            for (auto &[var, pos] : current_var_to_pos.at(common_to)) {
                std::cout << "?" << var << " -> " << "?" << normalized_var_map.at(var);
                if (++x != current_var_to_pos.at(common_to).size()) std::cout << ", ";
            }
            std::cout << std::endl;
#endif

            return true;
        }

        return false;
    }

    static void compute_pos_remapping(std::unordered_map<ll, ll> &remapping, std::unordered_map<ll, ll> &old_var_to_pos, std::unordered_map<ll, ll> &new_var_to_pos) {
        for (auto &[var, pos] : old_var_to_pos) {
            if (new_var_to_pos.contains(var)) {
                remapping.emplace(pos, new_var_to_pos.at(var));
            }
        }
    }

    void JoinOrderGraph::try_optimized_build(vector<const AnnotatedJoinOrderElement *> &delayed_elements, vector<NodeId> &current_node, vector<std::unordered_map<ll, ll>> &current_var_to_pos, const AnnotatedJoinOrderElement *first_el /*for debugging only*/) {
        if (delayed_elements.empty()) {
            return;
        }
        auto common_to = (**delayed_elements.begin()).element.to_id;
        auto &first_tracked_pars = (**delayed_elements.begin()).pars_tracked;

#ifndef NDEBUG
        // validate same to and same tracked pars
        for (auto &el : delayed_elements) {
            assert(common_to == el->element.to_id);
            assert(first_tracked_pars == el->pars_tracked);
        }
#endif

        std::set<ll> je_exists; // used to prefer original join order
        for (ll i = 0; i < delayed_elements.size(); i++) {
            je_exists.insert(i);
        }

        std::vector<MultipleJoinMatchHash> computed_hashes;
        std::vector<std::unordered_map<ll,ll>> old_var_to_poses;
        std::vector<std::unordered_map<ll,ll>> first_from_pos_to_varses;

        while (!je_exists.empty()) {
            ll match = -1;
            MultipleJoinMatchHash computed_h;
            std::unordered_map<ll,ll> first_from_pos_to_var;
            if (try_match_all_to(common_to, first_tracked_pars, je_exists, delayed_elements, current_node, current_var_to_pos, computed_h, first_from_pos_to_var)) {
                break;
            }
            old_var_to_poses.push_back(current_var_to_pos.at(common_to));
            computed_hashes.push_back(computed_h);
            first_from_pos_to_varses.push_back(first_from_pos_to_var);

            for (auto i : je_exists) {
                auto &join = *delayed_elements.at(i);
                if (build_simple_process_je_element(current_node,
                                                    current_var_to_pos,
                                                    join,
                                                    true)) {
#ifdef JOG_DEBUG_FLAG_PRINT_BUILD_PROCESS_NODE_CREATION
                    cout << "Delayed match for join element " << &join - first_el << " was ";
                    print_node(current_node[join.element.to_id]);
                    cout << endl;
#endif
                    match = i;
                    break;
                }
            }

            if (match == -1) {
                match = *je_exists.begin();
                auto &join = *delayed_elements.at(match);
                auto res = build_simple_process_je_element(current_node,
                                                           current_var_to_pos,
                                                           join,
                                                           false);
#ifdef JOG_DEBUG_FLAG_PRINT_BUILD_PROCESS_NODE_CREATION
                cout << "Delayed construction for join element " << &join - first_el << " was ";
                print_node(current_node[join.element.to_id]);
                cout << " representing: ";
                InitCollection atoms_underlying;
                std::vector<ll> ignore;
                auto node = current_node.at(join.element.to_id);
                collect_atoms(atoms_underlying, QueryEval::NO_NODE, ignore, &node);
                print_init_collection(atoms_underlying);
                std::cout << " with var map ";
                ll y = 0;
                for (auto &[var, pos] : current_var_to_pos.at(common_to)) {
                    std::cout << "?" << var << " -> " << pos;
                    if (++y != current_var_to_pos.at(common_to).size()) std::cout << ", ";
                }
                std::cout << endl;
#endif
                assert(res);
            }

            je_exists.erase(match); //TODO: could probably pass pointer from iteration
        }

        assert(computed_hashes.size() == old_var_to_poses.size());
        auto &new_var_to_pos = current_var_to_pos.at(common_to);

        ll i = 0;
        for (auto &h : computed_hashes) {
            auto &old_var_to_pos = old_var_to_poses.at(i++);
            std::unordered_map<ll, ll> remapping_to;
            compute_pos_remapping(remapping_to, old_var_to_pos, new_var_to_pos);
            std::unordered_map<ll, ll> remapping_from;
            if (old_var_to_pos.size() != new_var_to_pos.size()) {
                //TODO: clean this up;
                assert(old_var_to_pos.size() < new_var_to_pos.size());
                std::unordered_set<ParRef> missing_vars;
                for (auto &[var, pos] : new_var_to_pos) {
                    missing_vars.insert(var);
                }
                for (auto &[var, pos] : old_var_to_pos) {
                    missing_vars.erase(var);
                }
#ifndef NDEBUG
                // verify all nodes contain other pos-var;

                for (auto i : je_exists) {
                    for (auto var : missing_vars) {
                        assert(current_var_to_pos.at(delayed_elements.at(i)->element.from_id)
                                   .contains(var));
                    }
                }

                assert(missing_vars.size() == (new_var_to_pos.size() - old_var_to_pos.size()));
#endif
                auto &first_from_pos_to_var = first_from_pos_to_varses.at(i-1);
#ifndef NDEBUG
                for (auto var : missing_vars) {
                    assert(std::find_if(first_from_pos_to_var.begin(), first_from_pos_to_var.end(), [var](const std::pair<ll,ll> &el) {
                               return el.second == var;
                           }) != first_from_pos_to_var.end());
                }
#endif
                assert(first_from_pos_to_var.size() >= missing_vars.size());
                for (auto &[pos, var] : first_from_pos_to_var) {
                    if (missing_vars.contains(var)) {
                        assert(new_var_to_pos.contains(var));
                        assert(!remapping_from.contains(pos));
                        remapping_from.emplace(pos, new_var_to_pos.at(var));
                    }
                }
                assert(remapping_from.size() == missing_vars.size());
            }

            assert(!multiple_join_matches.contains(h));
            multiple_join_matches.emplace(h, make_tuple(current_node[common_to], remapping_to, remapping_from));
            assert(remapping_to.size() + remapping_from.size() == new_var_to_pos.size());
        }

        delayed_elements.clear();
        assert(current_var_to_pos.at(common_to).size() == first_tracked_pars.size());
    }

    static std::vector<ParRef> NO_PARS_TRACKED = {-142};

    static bool var_breaks(AnnotatedJoinOrderElement &join, std::vector<ParRef> &pars_tracked_before) {
        if (pars_tracked_before == NO_PARS_TRACKED) {
            return false;
        }

        return pars_tracked_before != join.pars_tracked;
    }

    static void compute_var_breaker(unordered_set<ll> &var_breaker, AnnotatedJoinOrder &join_order, Query &query) {
        vector<std::vector<ParRef>> current_pars_tracked(query.size(), NO_PARS_TRACKED);

        // var breaker by different pars_tracked
        ll jo_id = 0;
        for (auto &join : join_order) {
            if (var_breaks(join, current_pars_tracked[join.element.to_id])) {
                var_breaker.insert(jo_id);
            }
            current_pars_tracked[join.element.to_id] = join.pars_tracked;

            jo_id++;
        }

        // last join
        std::unordered_set<ll> last_join;
        std::vector<char> seen(query.size(), false);

        jo_id = join_order.size()-1;
        for (auto rit = join_order.rbegin(); rit != join_order.rend(); ++rit) {
            auto &el = *rit;
            if (!seen.at(el.element.to_id)) {
                last_join.insert(jo_id);
                seen[el.element.to_id] = true;
            }
            jo_id--;
        }

        // var breaker by introducing var that is not yet contained in next join element
        std::vector<ll> additional_var_breaker;
        jo_id = 0;
        std::vector<std::unordered_set<ParRef>> current_pars(query.size());
        for (ll i = 0; i < query.size(); i++) {
            auto &el = query.get_atom(i);
            for (auto pot_par : el.get_args()) {
                assert(pot_par.is_variable());
                current_pars.at(i).insert(pot_par.get_index());
            }
        }

        std::vector<ll> last_var_breakers(query.size(), -1);
        for (auto &el : join_order) {
            bool adjust = false;
            if (var_breaker.contains(jo_id)) { // TODO: combine with below
                adjust = true;
            }

            auto &from_pars = current_pars.at(el.element.from_id);
            auto &to_pars = current_pars.at(el.element.to_id);
            for (auto par : el.pars_tracked) {
                if (!to_pars.contains(par)) {  // to doesn't contain tracked par yet
                    if (!from_pars.contains(par)) {
                        additional_var_breaker.push_back(jo_id);
                        adjust = true;
                        break;
                    }
                }
            }

            if (adjust) {
                auto &last_var_breaker = last_var_breakers.at(el.element.to_id);
                if (last_var_breaker != -1) {
                    auto &last_pars_tracked = join_order.at(last_var_breaker).pars_tracked;
                    current_pars.at(el.element.to_id) =
                        std::unordered_set<ParRef>(last_pars_tracked.begin(), last_pars_tracked.end());
                }
                last_var_breaker = jo_id;
            }

            if (last_join.contains(jo_id)) {
                current_pars.at(el.element.to_id) =
                    std::unordered_set<ParRef>(el.pars_tracked.begin(), el.pars_tracked.end());
            }

            jo_id++;
        }

        for (auto breaker : additional_var_breaker) {
            var_breaker.insert(breaker);
        }
    }

    static void arg_remap(std::vector<ParRef> &new_args, const std::vector<ParRef> &old_args, std::unordered_map<ll, ll> &par_remapping) { //TODO: combine with below?
        for (auto par : old_args) {
            assert(par_remapping.contains(par));
            new_args.emplace_back(par_remapping.at(par));
        }
    }

    static void arg_remap(std::vector<ParameterOrObject> &new_args, const std::vector<ParameterOrObject> &old_args, std::unordered_map<ll, ll> &par_remapping) {
        for (auto &pot_par : old_args) {
            assert(pot_par.is_variable());
            auto par = pot_par.get_index();
            assert(par_remapping.contains(par));
            new_args.emplace_back(true, par_remapping.at(par));
        }
    }

    /* RIP normalize_query_pars_by_join_order @ 1fd4a6939c3a3e86e51a5852685fb46d84e7354a */

    void JoinOrderGraph::build_simple(Query &query, AnnotatedJoinOrder &join_order, DBInfo &info, std::map<ll, NodeId> *predicate_node_map) {
        Parameters &result_pars = query.get_result_pars();
        assert(query.size() > 0);
        vector<NodeId> current_node(query.size(), NO_NODE);
        vector<vector<const AnnotatedJoinOrderElement *>> delayed_jo_elements(query.size(), vector<const AnnotatedJoinOrderElement *>()); // to -> { set of delayed join order element ids (positions) }
        vector<std::unordered_map<ll, ll>> current_var_to_pos(query.size());
        unordered_set<ll> var_breaker; // contains join order elements <from, to> that have to be processed before the next <from', to> to create the right annotated variables
        if (enable_syntactic_query_match_for_jo) compute_var_breaker(var_breaker, join_order, query);

#ifdef JOG_DEBUG_FLAG_PRINT_BUILD_PROCESS
        cout << "Starting build_simple." << endl;
        for (ll i = 0; i < query.size(); i++) {
            std::cout << i << ": ";
            print_query_el(query.get_atom(i));
            if (i < query.size()-1) std::cout << ", ";
        }
        std::cout << endl;
#endif

#ifdef JOG_DEBUG_FLAG_PRINT_BUILD_PROCESS_JO
        for (auto &join : join_order) {
            ll from = join.element.from_id;
            ll to = join.element.to_id;

            print_query_el(query.get_atom(from));
            cout << " -> ";
            print_query_el(query.get_atom(to));
            cout << ", " << "[pars joined: ";
            print_pars(join.pars_joined);
            cout << ", pars tracked: ";
            print_pars(join.pars_tracked);
            cout << "]" << endl;
        }
        cout << endl;
#endif

        ll jo_id = 0;
        for (auto &join : join_order) {
            ll from = join.element.from_id;
            ll to = join.element.to_id;
            assert(from != to);

            init_if_needed(query, from, current_node, current_var_to_pos, predicate_node_map, info);
            init_if_needed(query, to, current_node, current_var_to_pos, predicate_node_map, info);

            if (enable_syntactic_query_match_for_jo) {
                // delayed nodes for from have to be processed
                try_optimized_build(delayed_jo_elements.at(from), current_node, current_var_to_pos, &*join_order.begin());

                // delayed nodes to to only have to be processed if annotation is not right anymore //TODO important: could make more sense to compute annotation here on demand then
                if (var_breaker.contains(jo_id)) {
                    try_optimized_build(
                        delayed_jo_elements.at(to), current_node, current_var_to_pos, &*join_order.begin());
                }

                delayed_jo_elements.at(to).push_back(&join);
                jo_id++;
            } else {
                auto res = build_simple_process_je_element(current_node, current_var_to_pos, join, false);
                assert(res);

                /* TODO: r_negated support -- if (to_needs_init && query.get_atom(to).is_negated()) {
                    mark_r_negated(current_node[to]);
                }*/
            }
            assert(current_var_to_pos.at(to).size() == get_pos_size(current_node.at(to)));
        }

        if (enable_syntactic_query_match_for_jo) {
            // process previously delayed nodes for last element
            if (!join_order.empty()) {
                try_optimized_build(delayed_jo_elements.at(join_order.back().element.to_id), current_node, current_var_to_pos, &*join_order.begin());
            }

#ifndef NDEBUG
            for (auto &s : delayed_jo_elements) {
                assert(s.empty());
            }
#endif
        }

        NodeId last_node;
        std::unordered_map<ll, ll> *last_var_to_pos;
        if (query.size() == 1) {
            init_if_needed(query, 0, current_node, current_var_to_pos, predicate_node_map, info);
            last_node = current_node[0];
            last_var_to_pos = &current_var_to_pos[0];
        } else {
            last_node = current_node[join_order.back().element.to_id];
            last_var_to_pos = &current_var_to_pos[join_order.back().element.to_id];
        }

        create_and_mark_result(last_node, result_pars, *last_var_to_pos);

#ifndef NDEBUG
        // check that graph links were built correctly in both directions from <-> to
        ll i = 0;
        for (auto &r_node : reorder_nodes) {
            auto id = ReorderId(i++);
            // from contains r_node
            assert(std::find(get(r_node.from).edges.begin(), get(r_node.from).edges.end(), id) != get(r_node.from).edges.end());
            for (auto to : r_node.edges) {
                to_has_from(id, to);
            }
        }

        i = 0;
        for (auto &i_node : init_nodes) {
            auto id = InitializerId(i++);
            for (auto to : i_node.edges) {
                to_has_from(id, to);
            }
        }

        i = 0;
        for (auto &m_node : merge_nodes) {
            auto id = MergeId(i++);

            assert(std::find(get(m_node.left).edges.begin(), get(m_node.left).edges.end(), id) != get(m_node.left).edges.end());
            assert(std::find(get(m_node.right).edges.begin(), get(m_node.right).edges.end(), id) != get(m_node.right).edges.end());

            for (auto to : m_node.edges) {
                to_has_from(id, to);
            }
        }
#endif


#ifdef JOG_DEBUG_FLAG_PRINT_BUILD_PROCESS
        cout << "Creation was: " << endl;

        InitCollection atoms_underlying;
        std::vector<ll> ignore;
        auto node = get_last_request_node();
        collect_atoms(atoms_underlying, QueryEval::NO_NODE, ignore, &node);
        print_init_collection(atoms_underlying);
        std::cout << endl;
#endif
    }

    NodeId JoinOrderGraph::create_new_predicate_initializer(ll predicate_id, std::vector<ll> &pos_order, DBInfo &info) {
        init_nodes.push_back(PredicateInit(predicate_id, pos_order, arr_id_count++, info));
        NodeId id = InitializerId(init_nodes.size()-1);
        if (!predicate_init_node.contains(predicate_id)) {
            predicate_init_node.emplace(predicate_id, std::map<std::vector<ll>, NodeId>());
        } else {
#ifdef JOG_DEBUG_FLAG_PRINT_NODE_CACHE_HIT_TYPE
#ifndef JOG_DEBUG_FLAG_PRINT_NODE_CACHE_HIT_TYPE_NO_PRED
            std::cout << "Cache hit: predicate" << std::endl;
#endif
#endif
        }
        predicate_init_node.at(predicate_id).emplace(pos_order, id);
        return id;
    }

    NodeId JoinOrderGraph::create_new_predicate_initializer(ll predicate_id, ll predicate_arity, DBInfo &info) {
        vector<ll> pos_order;
        for (ll i = 0; i < predicate_arity; i++) {
            pos_order.push_back(i);
        }
        return create_new_predicate_initializer(predicate_id, pos_order, info);
    }

    NodeId JoinOrderGraph::get_predicate_initializer(ll predicate_id, ll predicate_arity, std::vector<ll> &reorder, DBInfo &info) {
        if (!predicate_init_node.contains(predicate_id)) {
            create_new_predicate_initializer(predicate_id, predicate_arity, info);
        }

        auto it = predicate_init_node.at(predicate_id).begin();
        reorder = it->first;
        return it->second;
    }

    NodeId JoinOrderGraph::build_initialize(Atom &atom, std::vector<ll> &reorder, DBInfo &info) {
        return get_predicate_initializer(atom.get_predicate(), atom.get_arity(), reorder, info);
    }

    void JoinOrderGraph::compute_joined_positions(std::vector<PositionMerge> &vars_to_join, NodeId to, NodeId from) {
        if (to.is_init()) { //TODO: make visitor
            assert(false && "shouldn't happen");
        } else if (to.is_merge()) {
            auto &to_node = static_cast<MergeNode &>(get(to));

            ll join_pos = 0;
            if (from == to_node.left) {
                for (auto &el : to_node.joined_positions) {
                    vars_to_join.push_back({el.to, el.from_left, join_pos++});
                }
                for (auto &el : to_node.left_positions_forward) {
                    vars_to_join.push_back({el.to, el.from, join_pos++});
                }
            } else {
                for (auto &el : to_node.joined_positions) {
                    vars_to_join.push_back({el.to, el.from_right, join_pos++});
                }
                for (auto &el : to_node.right_positions_forward) {
                    vars_to_join.push_back({el.to, el.from, join_pos++});
                }
            }
        } else if (to.is_reorder()) {
            // TODO (important) could skip reorder nodes in the future
            auto &to_node = static_cast<ReOrderNode &>(get(to));

            ll join_pos = 0;
            for (auto &el : to_node.re_order) {
                vars_to_join.push_back({el.to, el.from, join_pos++});
            }
        } else {
            assert(false && "shouldn't happen");
        }
    }

    static void get_reorder(std::unordered_map<ll, ll> &reorder, std::vector<PositionForward> &pfw) {
        for (auto &[from, to] : pfw) {
            reorder.emplace(from, to);
        }
    }

    void insert_new_var_to_pos(std::unordered_map<ll, ll> &new_var_to_pos, std::unordered_map<ll, ll> &var_to_pos, std::unordered_map<ll, ll> &reorder) {
        for (auto &[var, pos] : var_to_pos) {
            if (reorder.contains(pos)) {
                assert(!new_var_to_pos.contains(var) || new_var_to_pos.at(var) == reorder.at(pos));
                new_var_to_pos.emplace(var, reorder.at(pos));
            }
        }
    }

    void JoinOrderGraph::get_new_var_to_pos(std::unordered_map<ll, ll> &new_var_to_pos,  std::unordered_map<ll, ll> &var_to_pos, NodeId end_node, NodeId part_of_merge) {
        if (part_of_merge != end_node) {
            assert(part_of_merge.is_reorder());
            auto &reorder_node = static_cast<ReOrderNode&>(get(part_of_merge));

            assert(reorder_node.from == end_node);
            std::unordered_map<ll, ll> reorder;
            get_reorder(reorder, reorder_node.re_order);

            insert_new_var_to_pos(new_var_to_pos, var_to_pos, reorder);
        } else {
            assert(part_of_merge == end_node);
            new_var_to_pos = var_to_pos;
        }
    }

    void JoinOrderGraph::validate_leads_to(NodeId from, NodeId to, bool over_left) {
#ifndef NDEBUG
        assert(to.is_merge());
        auto &m_node = static_cast<MergeNode&>(get(to));
        NodeId looking_over = over_left ? m_node.left : m_node.right;

        if (looking_over == from) {
            // matched already
            return;
        }

        // otherwise continue one deeper over reorder
        assert(looking_over.is_reorder());
        auto &lo_node = static_cast<ReOrderNode&>(get(looking_over));
        assert(lo_node.from == from);
#endif
    }

    void JoinOrderGraph::validate_result_leads_to(std::unordered_map<ll, ll> original_var_to_pos /*should be copy so that we can modify it*/,
                                                    NodeId transformer_node,
                                                    std::unordered_map<ll, ll> &transformed_var_to_pos,
                                                    std::unordered_set<ll> &vars_covered,
                                                    std::unordered_set<ll> &pos_covered,
                                                    NodeId m_node,
                                                    bool is_left) {
#ifndef NDEBUG
        // adjust by reorder
        if (transformer_node.is_reorder()) {
            auto &r_node = static_cast<ReOrderNode &>(get(transformer_node));
            std::unordered_map<ll, ll> original_pos_to_var;
            for (auto &[var, pos] : original_var_to_pos) {
                pos_covered.insert(pos);
                original_pos_to_var.emplace(pos, var);
            }

            std::unordered_map<ll, ll> new_original_var_to_pos;
            for (auto &[from, to] : r_node.re_order) {
                assert(original_pos_to_var.contains(from));
                new_original_var_to_pos.emplace(original_pos_to_var.at(from), to);
            }
            original_var_to_pos = new_original_var_to_pos;

            assert(!r_node.from.is_reorder());
        }

        // adjust by merge
        std::unordered_map<ll, ll> original_pos_to_var;
        for (auto &[var, pos] : original_var_to_pos) {
            pos_covered.insert(pos);
            original_pos_to_var.emplace(pos, var);
        }
        std::unordered_map<ll, ll> new_original_var_to_pos;
        assert(m_node.is_merge());
        auto &m_node_x = static_cast<MergeNode&>(get(m_node));
        for (auto &joined : m_node_x.joined_positions) {
            assert(original_pos_to_var.contains(is_left ? joined.from_left : joined.from_right));
            new_original_var_to_pos.emplace(original_pos_to_var.at(is_left ? joined.from_left : joined.from_right), joined.to);
        }
        for (auto &[from, to] : (is_left ? m_node_x.left_positions_forward : m_node_x.right_positions_forward)) {
            assert(original_pos_to_var.contains(from));
            new_original_var_to_pos.emplace(original_pos_to_var.at(from), to);
        }
        original_var_to_pos = new_original_var_to_pos;

        // check mapping is correct
        for (auto &[var, pos] : original_var_to_pos) {
            assert(transformed_var_to_pos.contains(var));
            assert(transformed_var_to_pos.at(var) == pos);
            vars_covered.insert(var);
        }
#endif
    }

    static std::unordered_set<ll> pseudo_get_domain(std::unordered_map<ll, ll> &var_to_pos) {
        std::unordered_set<ll> dom;
        for (auto &[from, _] : var_to_pos) {
            dom.insert(from);
        }
        return dom;
    }

    static std::unordered_set<ll> pseudo_get_range(ll bound) {
        std::unordered_set<ll> dom;
        for (ll i = 0; i < bound; i++) {
            dom.insert(i);
        }
        return dom;
    }

    void JoinOrderGraph::validate_join_node(QueryEval::NodeId left, QueryEval::NodeId right, QueryEval::NodeId match,
                                            std::unordered_map<ll, ll> &l_var_to_pos,
                                            std::unordered_map<ll, ll> &r_var_to_pos,
                                            std::unordered_map<ll, ll> &result_var_to_pos) {
#ifndef NDEBUG
        assert(match.is_merge());
        auto &m_node = static_cast<MergeNode&>(get(match));
        assert(m_node.joined_positions.size() + m_node.left_positions_forward.size() + m_node.right_positions_forward.size() == result_var_to_pos.size());
        std::unordered_set<ll> vars_covered;
        std::unordered_set<ll> pos_covered;
        // validate that merge node is connect to left and right node that shall be joined
        validate_leads_to(left, match, true);
        validate_leads_to(right, match, false);
        // validate that variables are remapped correctly
        validate_result_leads_to(l_var_to_pos, m_node.left, result_var_to_pos, vars_covered, pos_covered, match, true);
        validate_result_leads_to(r_var_to_pos, m_node.right, result_var_to_pos, vars_covered, pos_covered, match, false);
        // validate all variables are contained in result
        assert(vars_covered == pseudo_get_domain(result_var_to_pos));
        assert(vars_covered.size() == result_var_to_pos.size());
#endif
    }

    NodeId JoinOrderGraph::build_join_by_rule(QueryEval::NodeId left, QueryEval::NodeId right, std::unordered_map<ll, ll> &l_var_to_pos, std::unordered_map<ll, ll> &r_var_to_pos,
                                              const QueryEval::AnnotatedJoinOrderElement &el, std::unordered_map<ll, ll> &result_var_to_pos, bool try_match_only) { //TODO: combine with build_semi_join by just passing the right field of parameters
        auto &left_node = get(left);
        auto &right_node = get(right);

        std::unordered_map<ll, ll> original_l_var_to_pos; // only used for debug validation
        std::unordered_map<ll, ll> original_r_var_to_pos; // only used for debug validation
#ifndef NDEBUG
        original_l_var_to_pos = l_var_to_pos;
        original_r_var_to_pos = r_var_to_pos;
#endif

        vector<PositionForward> left_vars_to_forward;
        vector<PositionForward> right_vars_to_forward;
        vector<PositionMerge> vars_to_join;

        ll pos = 0;
        for (ll var : el.pars_tracked) {
            if (l_var_to_pos.contains(var)) {
                if (r_var_to_pos.contains(var)) {
                    assert(std::find(el.pars_joined.begin(), el.pars_joined.end(), var) != el.pars_joined.end()); //TODO: should probably get rid of .pars_joined
                    vars_to_join.push_back({l_var_to_pos.at(var), r_var_to_pos.at(var), pos});
                } else {
                    left_vars_to_forward.push_back({l_var_to_pos.at(var), pos});
                }
            } else {
                assert(r_var_to_pos.contains(var));
                right_vars_to_forward.push_back({r_var_to_pos.at(var), pos});
            }
            result_var_to_pos.emplace(var, pos);
            pos++;
        }

        if (enable_syntactic_query_match) {
            CreateJoinNodeCacheHash h(left, right, left_vars_to_forward, right_vars_to_forward, vars_to_join);

            if (join_matches.contains(h)) {
                result_var_to_pos.clear();
                auto match = join_matches.at(h);

                assert(match.is_merge());
                auto &merge = static_cast<MergeNode&>(get(match));

#ifdef JOG_DEBUG_FLAG_PRINT_NODE_CACHE_HIT_TYPE
                std::cout << "Cache hit: join" << std::endl;
#endif

                // var to pos for merge.left
                unordered_map<ll, ll> new_l_var_to_pos;
                get_new_var_to_pos(new_l_var_to_pos, l_var_to_pos, left, merge.left);

                // var to pos for merge.right
                unordered_map<ll, ll> new_r_var_to_pos;
                get_new_var_to_pos(new_r_var_to_pos, r_var_to_pos, right, merge.right);

                std::unordered_map<ll, ll> l_reorder;
                get_reorder(l_reorder, merge.left_positions_forward);

                std::unordered_map<ll, ll> r_reorder;
                get_reorder(r_reorder, merge.right_positions_forward);

                for (auto &m_descr : merge.joined_positions) {
                    l_reorder.emplace(m_descr.from_left, m_descr.to);
                    r_reorder.emplace(m_descr.from_right, m_descr.to);
                }

                insert_new_var_to_pos(result_var_to_pos, new_l_var_to_pos, l_reorder);
                insert_new_var_to_pos(result_var_to_pos, new_r_var_to_pos, r_reorder);

                validate_join_node(left, right, match, original_l_var_to_pos, original_r_var_to_pos, result_var_to_pos);
                return match;
            }

            if (try_match_only) {
                return NO_NODE;
            }
        }

        // for hash creation (other vectors will be modified during join creation)
        vector<PositionForward> original_left_vars_to_forward = left_vars_to_forward;
        vector<PositionForward> original_right_vars_to_forward = right_vars_to_forward;
        vector<PositionMerge> original_vars_to_join = vars_to_join;

        auto top_node = create_join_node(left, right, left_vars_to_forward, right_vars_to_forward, vars_to_join, &result_var_to_pos, &original_l_var_to_pos, &original_r_var_to_pos);

        if (enable_syntactic_query_match) {
            CreateJoinNodeCacheHash h(left, right, original_left_vars_to_forward, original_right_vars_to_forward, original_vars_to_join);
            join_matches.emplace(h, top_node);
        }

        validate_join_node(left, right, top_node, original_l_var_to_pos, original_r_var_to_pos, result_var_to_pos);
        return top_node;
    }

    static void partial_adjust_var_to_pos(std::unordered_map<ll, ll> &var_to_pos, std::unordered_map<ll, ll> &re_reorder) {
        auto re_reorder_copy = re_reorder;
        for (auto &[var, pos] : var_to_pos) {
            if (!re_reorder.contains(pos)) {
                assert(!re_reorder_copy.contains(pos));
                re_reorder_copy.emplace(pos, pos);
            }
        }
        adjust_var_to_pos(var_to_pos, re_reorder_copy);
    }

    static void re_order_adjust(std::vector<PositionForward> &vars_to_forward, std::unordered_map<ll, ll> &re_reorder, std::vector<PositionMerge> &join_rules, std::unordered_map<ll, ll> &var_to_pos, bool is_left) {
#ifndef NDEBUG
        for (auto &m_rule : join_rules) {
            auto from = is_left ? m_rule.from_left : m_rule.from_right;
            assert(re_reorder.at(from) == from);
        }
#endif

        std::unordered_map<ll, ll> to_reorder;
        adjust_pfw(vars_to_forward, re_reorder, to_reorder);
        partial_adjust_var_to_pos(var_to_pos, to_reorder);
    }

    static void validate_injective(std::unordered_map<ll, ll> &m) {
#ifndef NDEBUG
        std::unordered_set<ll> seen;
        for (auto &[var, val] : m) {
            assert(!seen.contains(val));
            seen.insert(val);
        }
#endif
    }

    static void validate_normalized(std::vector<PositionForward> &left_vars_to_forward,
                                    std::vector<PositionForward> &right_vars_to_forward,
                                    std::vector<PositionMerge> &join_rules) {
#ifndef NDEBUG
        // merge
        for (auto &join_rule : join_rules) {
            assert(join_rule.to < join_rules.size());
            assert(join_rule.from_left < join_rules.size());
            assert(join_rule.from_right < join_rules.size());

            assert(join_rule.to == join_rule.from_left);
            assert(join_rule.to == join_rule.from_right);
        }

        // left forward
        for (auto &[from, to] : left_vars_to_forward) {
            assert(from < left_vars_to_forward.size() + join_rules.size());
            assert(from >= join_rules.size());
            assert(to < left_vars_to_forward.size() + join_rules.size());
            assert(to >= join_rules.size());

            assert(to == from);
        }

        // right forward
        for (auto &[from, to] : right_vars_to_forward) {
            assert(from < right_vars_to_forward.size() + join_rules.size());
            assert(from >= join_rules.size());
            assert(to < left_vars_to_forward.size() + join_rules.size() + right_vars_to_forward.size());
            assert(to >= left_vars_to_forward.size() + join_rules.size());

            assert(to == from + left_vars_to_forward.size());
        }
#endif
    }

    static void perform_variable_pos_remap(const std::unordered_map<ll, ll> &original,
                                           const std::unordered_map<ll, ll> &remapping_map,
                                           std::unordered_map<ll, ll> &result) {
        for (auto &[var, pos] : original) {
            assert(!result.contains(var));
            if (remapping_map.contains(pos)) {
                result.emplace(var, remapping_map.at(pos));
            }
        }
    }

    static void validate_reorder_for_join(const std::vector<PositionForward> &node_reorder,
                                          const std::vector<PositionForward> &remapping,
                                          const std::vector<PositionMerge> &join_rules,
                                          const std::unordered_map<ll, ll> &original_var_to_pos,
                                          const std::unordered_map<ll, ll> &final_var_to_pos,
                                          bool is_left) {
#ifndef NDEBUG
        std::unordered_map<ll, ll> new_var_to_pos;
        std::unordered_map<ll, ll> node_as_map;

        for (auto &[from, to] : node_reorder) {
            node_as_map.emplace(from, to);
        }

        perform_variable_pos_remap(original_var_to_pos, node_as_map, new_var_to_pos);

        std::unordered_map<ll, ll> result;
        std::unordered_map<ll, ll> remapping_as_map;
        for (auto &[from, to] : remapping) {
            remapping_as_map.emplace(from, to);
        }

        for (auto &m : join_rules) {
            auto from = is_left ? m.from_left : m.from_right;
            assert(!remapping_as_map.contains(from));
            remapping_as_map.emplace(from, m.to);
        }
        perform_variable_pos_remap(new_var_to_pos, remapping_as_map, result);

        // (partial) result == final_var_to_pos
        for (auto &[var, pos] : result) {
            assert(final_var_to_pos.contains(var));
            assert(pos == final_var_to_pos.at(var));
        }
#endif
    }

    NodeId JoinOrderGraph::create_join_node(QueryEval::NodeId left, QueryEval::NodeId right,
                                            std::vector<PositionForward> &left_vars_to_forward,
                                            std::vector<PositionForward> &right_vars_to_forward,
                                            std::vector<PositionMerge> &join_rules,
                                            std::unordered_map<ll, ll> *var_to_pos, /*flags if reorders shall be created*/
                                            const std::unordered_map<ll, ll> *original_l_var_to_pos, /*For debug/validation only*/
                                            const std::unordered_map<ll, ll> *original_r_var_to_pos  /*For debug/validation only*/) {

        if (var_to_pos) {
            assert(original_l_var_to_pos);
            assert(original_r_var_to_pos);
            validate_injective(*var_to_pos);
            // normalize join order to 0...|end join|...|end left forward|...|end right forward|
            reorder_joins(join_rules,
                          left_vars_to_forward,
                          right_vars_to_forward,
                          *var_to_pos);  // TODO: explain order reasoning, merge, left, right
            validate_injective(*var_to_pos);

            // order joined part so that it is more likely to find a match
            std::sort(join_rules.begin(), join_rules.end(), [](const PositionMerge &l, const PositionMerge &r){
                if (l.from_left < r.from_left) {
                    return true;
                } else if (l.from_left < r.from_left) {
                    return false;
                }

                if (l.from_right < r.from_right) {
                    return true;
                } else if (l.from_right < r.from_right) {
                    return false;
                }

                if (l.to < r.to) {
                    return true;
                }

                return false;
            });

            std::unordered_map<ll, ll> reorder_join_to;
            for (ll i = 0; i < join_rules.size(); i++) {
                reorder_join_to.emplace(join_rules.at(i).to, i);
                join_rules.at(i).to = i;
            }

            std::unordered_map<ll, ll> new_var_to_pos;
            for (auto &[var, pos] : *var_to_pos) {
                assert(reorder_join_to.contains(pos) || pos >= join_rules.size());
                new_var_to_pos.emplace(var, reorder_join_to.contains(pos) ? reorder_join_to.at(pos) : pos);
            }
            validate_injective(new_var_to_pos);
            *var_to_pos = new_var_to_pos;

            // construct reorder, if reorder did not need to be constructed but was retrieved from cache, we need to adjust
            std::unordered_map<ll, ll> re_reorder;
            left = construct_reorder(left, join_rules, left_vars_to_forward, true, 0, &re_reorder);
            assert(left.is_reorder());
            if (!re_reorder.empty()) {
                re_order_adjust(left_vars_to_forward, re_reorder, join_rules, *var_to_pos, true);
                validate_injective(*var_to_pos);
            }
            validate_reorder_for_join(static_cast<ReOrderNode&>(get(left)).re_order, left_vars_to_forward, join_rules, *original_l_var_to_pos, *var_to_pos, true);

            std::unordered_map<ll, ll> second_re_reorder;
            right = construct_reorder(
                right, join_rules, right_vars_to_forward, false, left_vars_to_forward.size(), &second_re_reorder);
            assert(right.is_reorder());
            if (!second_re_reorder.empty()) {
                re_order_adjust(right_vars_to_forward, second_re_reorder, join_rules, *var_to_pos, false);
                validate_injective(*var_to_pos);
            }
            validate_reorder_for_join(static_cast<ReOrderNode&>(get(right)).re_order, right_vars_to_forward, join_rules, *original_r_var_to_pos, *var_to_pos, false);
        }

        validate_normalized(left_vars_to_forward, right_vars_to_forward, join_rules);

        NodeId id = MergeId(merge_nodes.size()); //TODO: replace with get latest ...

        if (enable_syntactic_query_match) {
            auto h_id = MergeNodeIdentifierHashKey{
                left, right, left_vars_to_forward, right_vars_to_forward, join_rules};

            if (merge_matches.contains(h_id)) {
                auto node = merge_matches.at(h_id);
                return node;
            } else {
                merge_matches.emplace(h_id, id);
            }
        }

        merge_nodes.emplace_back();
        MergeNode &node = merge_nodes.back();
        //TODO: move to constructor
        node.arr_id = arr_id_count++;
        node.left = left;
        node.right = right;
        node.left_positions_forward = left_vars_to_forward;
        node.right_positions_forward = right_vars_to_forward;
        node.joined_positions = join_rules;
        node.merge_node_depth = get(left).merge_node_depth + get(right).merge_node_depth + 1; //TODO: get only once
        node.is_static = get(left).is_static && get(right).is_static; //TODO: get only once

        get(left).edges.push_back(id);
        get(right).edges.push_back(id);

        return id;
    }

    std::vector<JoinOrderGraph::ExtNodeRepr> JoinOrderGraph::get_nodes() {
        std::vector<JoinOrderGraph::ExtNodeRepr> nodes;
        ll id = 0;
        for (auto &node : init_nodes) {
            nodes.emplace_back(JoinOrderGraph::ExtNodeRepr{InitializerId(id), {.init_node=&node}});
            id++;
        }
        id = 0;
        for (auto &node : merge_nodes) {
            nodes.push_back(JoinOrderGraph::ExtNodeRepr{MergeId(id), {.merge_node=&node}});
            id++;
        }
        id = 0;
        for (auto &node : reorder_nodes) {
            nodes.push_back(JoinOrderGraph::ExtNodeRepr{ReorderId(id), {.reorder_node=&node}});
            id++;
        }
        return nodes;
    }

    //TODO important: TODO important this seems a bit too restrictive for constant and equality mappings
    // e.g. =(?x, ?y) is implied by =(?x, ?y, ?z);
    // & a free variable ?x can always contain some object o and so validate the restriction =(?x, o)
    //TODO: should templatize the nullptr options
    void JoinOrderGraph::collect_atoms(InitCollection &init_collection, NodeId int_node,
                                       std::vector<ll> &vars_for_init, NodeId *single_request,
                                       std::unordered_map<ll, std::vector<ll>> *fail_annotation,
                                       TableCache *result_cache,
                                       std::unordered_map<QueryEval::NodeId, std::vector<std::pair<ll, ll>>> *jog_query_repr_mapping) { //TODO: make init_node optional -- isn't this the same as original request?
        // result cache and fail annotation signal the same additional mode
        assert(!(!!fail_annotation ^ !!result_cache) /*.*/);

        std::vector<map<ll,ll>> remappings;
        std::vector<ll> fail_ids;
        std::queue<std::pair<NodeId, size_t>> q; //node id, visit id (nodes can be visited multiple times during collection to create different atoms)
        std::unordered_set<NodeId> request_nodes;
        if (single_request) {
            request_nodes.insert(*single_request);
        } else { //TODO important: does this make any sense? - i do not think so
            for (auto &req: requests) { //TODO: cache this
                auto node = req.second.second;
                if (get(node).edges.empty()) {
                    request_nodes.insert(req.second.second);
                }
            }
        }
        ll new_var = 0; //TODO: shouldn't this be like parref, obj or whatever?

        for (auto &node : request_nodes) {
            q.push({node, remappings.size()});
            remappings.push_back({});

            if (result_cache) {
                assert(result_cache->get_node_table(get(node).arr_id).empty());
                fail_ids.push_back(-1);
            }
        }

        ll fail_id = 0;
        while (!q.empty()) { //TODO: would it make more sense to do this recursively?
            auto [node_id, visit_id] = q.front();
            auto &annotation = remappings[visit_id];
            q.pop();
            auto &_node = get(node_id);

            vector<ll> pos_to_var(get_pos_size(node_id));
            for (ll i = 0; i < pos_to_var.size(); i++) {
                if (annotation.contains(i)) {
                    pos_to_var[i] = annotation[i];
                } else {
                    pos_to_var[i] = new_var++;
                }
            }

            if (node_id == int_node) { //TODO: probably should move this out of loop
                vars_for_init = pos_to_var;
            }

            if (node_id.is_init()) { //TODO: make this a visitor?
                auto &node = static_cast<InitNode&>(_node);
                node.initializer->add_to_init(pos_to_var, init_collection);
                if (jog_query_repr_mapping) {
                    if (!jog_query_repr_mapping->contains(node_id)) {
                        jog_query_repr_mapping->emplace(node_id, std::vector<std::pair<ll,ll>>());
                    }

                    jog_query_repr_mapping->at(node_id).emplace_back(node.initializer->predicate,
                                                                     init_collection.predicate_init.at(node.initializer->predicate).size()-1);
                }

                if (result_cache) {
                    assert(fail_annotation);
                    if (result_cache->get_node_table(node.arr_id).empty()) {
                        assert(fail_ids[visit_id] == -1);
                        fail_ids[visit_id] = fail_id++;
                    }

                    if (!fail_annotation->contains(node.initializer->predicate)) {
                        fail_annotation->emplace(node.initializer->predicate, std::vector<ll>());
                    }
                    assert(init_collection.predicate_init.contains(node.initializer->predicate));
                    ll annotation = node.is_static ? -1 : fail_ids[visit_id];
                    fail_annotation->at(node.initializer->predicate).push_back(annotation);
                }
            } else if (node_id.is_merge()) {
                auto &node = static_cast<MergeNode&>(_node);
                map<ll,ll> left_annotation;
                map<ll,ll> right_annotation;

                if (result_cache
                    && result_cache->get_node_table(node.arr_id).empty()
                    && !result_cache->get_node_table(get(node.left).arr_id).empty()
                    && !result_cache->get_node_table(get(node.right).arr_id).empty()) {
                    assert(fail_ids[visit_id] == -1);
                    fail_ids[visit_id] = fail_id++;
                }

                for (auto &el : node.joined_positions) {
                    left_annotation[el.from_left] = pos_to_var[el.to];
                    right_annotation[el.from_right] = pos_to_var[el.to];
                }
                for (auto &el : node.left_positions_forward) {
                    left_annotation[el.from] = pos_to_var[el.to];
                }
                for (auto &el : node.right_positions_forward) {
                    right_annotation[el.from] = pos_to_var[el.to];
                }

                q.push({node.left, remappings.size()});
                remappings.push_back(left_annotation);
                if (result_cache) fail_ids.push_back(fail_ids[visit_id]);

                q.push({node.right, remappings.size()});
                remappings.push_back(right_annotation);
                if (result_cache) fail_ids.push_back(fail_ids[visit_id]);
            } else {
                assert(node_id.is_reorder());
                auto &node = static_cast<ReOrderNode&>(_node);
                map<ll,ll> new_annotation;

                for (auto &el : node.re_order) {
                    new_annotation[el.from] = pos_to_var[el.to];
                }
                q.push({node.from, remappings.size()});
                remappings.push_back(new_annotation);
                if (result_cache) fail_ids.push_back(fail_ids[visit_id]);
            }
        }
    }

    void JoinOrderGraph::extract_fail_nodes(TableCache &cache, NodeId from, std::unordered_map<QueryEval::NodeId, std::vector<ll>> &fail_annotation) {
        std::unordered_set<QueryEval::NodeId> seen; //TODO: important could be constant lookup
        std::queue<std::pair<NodeId, ll>> q;
        ll fail_id = 0;
        q.push({from, -1});

        while (!q.empty()) { //TODO: would it make more sense to do this recursively?
            auto [node_id, annotation] = q.front();
            q.pop();
            auto &_node = get(node_id);

            if (annotation == -1 && seen.contains(node_id)) {
                continue;
            }

            seen.insert(node_id);

            if (node_id.is_init()) { //TODO: make this a visitor?
                auto &node = static_cast<InitNode&>(_node);

                if (!fail_annotation.contains(node_id)) {
                    fail_annotation.emplace(node_id, std::vector<ll>());
                }

                if (cache.get_node_table(node.arr_id).empty()) {
                    assert(annotation == -1);
                    fail_annotation[node_id].push_back(node.is_static ? -1 : fail_id++);
#ifdef JOG_DEBUG_FLAG_PRINT_FAIL_EXTRACTION_INIT
                    std::cout << "Init node " << node_id.id_num << " explored with annotation != -1. (annotation: " << fail_id << ")" << std::endl;
#endif
                } else {
                    fail_annotation[node_id].push_back(node.is_static ? -1 : annotation);
#ifdef JOG_DEBUG_FLAG_PRINT_FAIL_EXTRACTION_INIT
                    if (annotation != -1) {
                        std::cout << "Init node " << node_id.id_num
                                  << " explored with annotation != -1. (annotation: " << annotation
                                  << ")" << std::endl;
                    }
#endif
                }
            } else if (node_id.is_merge()) {
                auto &node = static_cast<MergeNode&>(_node);
                map<ll,ll> left_annotation;
                map<ll,ll> right_annotation;

                if (cache.get_node_table(node.arr_id).empty()
                    && !cache.get_node_table(get(node.left).arr_id).empty()
                    && !cache.get_node_table(get(node.right).arr_id).empty()) {
                    assert(annotation == -1);
                    annotation = fail_id++;
                }

                q.push({node.left, annotation});
                q.push({node.right, annotation});
            } else {
                assert(node_id.is_reorder());
                auto &node = static_cast<ReOrderNode&>(_node);
                q.push({node.from, annotation});
            }
        }

        assert(!fail_annotation.empty());
    }

    void JoinOrderGraph::merge(MergeNode &node, TableCache &cache) {
        assert(!node.right_negated || node.right_positions_forward.empty());
        auto &merge_from_left = cache.get_node_table(get(node.left).arr_id);
        auto &merge_from_right = cache.get_node_table(get(node.right).arr_id);
        auto &result_table = cache.get_node_table(node.arr_id);

        if (node.right_negated) { //TODO: should be determined by class
            JoinTable::r_negated_merge(merge_from_left, merge_from_right, result_table,
                                       node.joined_positions, node.left_positions_forward, node.right_positions_forward);
        } else {
            JoinTable::merge(merge_from_left, merge_from_right, result_table,
                                       node.joined_positions, node.left_positions_forward, node.right_positions_forward);
        }
    }

    void JoinOrderGraph::reorder(QueryEval::ReOrderNode &node, TableCache &cache) {
        auto &from_table = cache.get_node_table(get(node.from).arr_id);
        auto &to_table = cache.get_node_table(node.arr_id);

        JoinTable::reorder(from_table, to_table, node.re_order);
    }

    void create_j_pfw(vector<PositionForward> &j_set, std::vector<PositionForward> &pfwd, std::vector<PositionMerge> &joined) {
        auto pfw_copy = pfwd;

        std::sort(pfw_copy.begin(), pfw_copy.end(), [](const PositionForward & a, const PositionForward & b) -> bool {
            return a.to < b.to;
        });

        set<ll> to_interesting;
        for (auto &m_rule : joined) {
            to_interesting.insert(m_rule.to);
        }

        for (auto &[from, to] : pfw_copy) {
            if (to_interesting.contains(to)) {
                j_set.push_back({from, to});
            }
        }
    }

    void JoinOrderGraph::verify_reorder(NodeId match, NodeId original_reorder, bool is_left, std::vector<PositionMerge> &joined) {
#ifndef NDEBUG
        // verify reorder match by checking that joins order is preserved
        assert(match.is_reorder());
        auto &match_node = static_cast<ReOrderNode&>(get(match));
        auto &reorder_node = static_cast<ReOrderNode&>(get(original_reorder));
        for (auto &fw_el : reorder_node.re_order) {
            assert(std::find_if(joined.begin(), joined.end(), [is_left, joined, fw_el](const PositionMerge &pm) {
                    return (is_left ? pm.from_left : pm.from_right) == fw_el.to;
                }) == joined.end()
            || std::find(match_node.re_order.begin(), match_node.re_order.end(), fw_el) != match_node.re_order.end());

        }
#endif
    }

    void determine_re_reorder(std::unordered_map<ll, ll>  &re_reorder, std::vector<PositionForward> &original_pfwd, std::vector<PositionForward> &new_pfwd) {
        std::unordered_map<ll, ll> new_as_map;
        for (auto &[from, to] : new_pfwd) {
            new_as_map.emplace(from, to);
        }

        for (auto &[from, to] : original_pfwd) {
            assert(!re_reorder.contains(to));
            assert(new_as_map.contains(from));
            re_reorder.emplace(to, new_as_map.at(from));
        }
    }

    //TODO: should probably be combined with task printout
    void JoinOrderGraph::dump_propositional_repr(NodeId node) {
        InitCollection init_collection;
        std::vector<ll> ignore;
        collect_atoms(init_collection, QueryEval::NO_NODE, ignore, &node);
        //TODO: make sure this collects all atoms (also doubled up)

        assert(!init_collection.predicate_init.empty());

        for (auto &[pr, vec] : init_collection.predicate_init) {
            std::cout << char('A' + pr) << "(";
            for (auto &vars : vec) {
                for (auto var : vars) {
                    std::cout << "?" << var << ", ";
                }
            }
            std::cout << "), ";
        }
    }

    static void validate_bijection(std::unordered_map<ll,ll> &re_reorder, bool strict = false) {
        // very specific for this setting validates that any elements are mapped to 0, ..., n-1
        // if strict, we also check that domain is 0, ..., n-1
#ifndef NDEBUG
        // make sure domain matches
        std::unordered_set<ll> values;
        for (auto &[from, to] : re_reorder) {
            assert(!strict || from < re_reorder.size());
            assert(to < re_reorder.size());
            values.insert(to);
        }
        assert(values.size() == re_reorder.size());
#endif
    }

    static void validate_bijection(std::vector<PositionForward> &re_order, ll forward_offset, bool is_left) {
        if (is_left) assert(!forward_offset);

        std::unordered_map<ll, ll> to_validate;
        for (auto &[from, to] : re_order) {
            assert(!to_validate.contains(from));
            to_validate.emplace(from, to);
        }
        validate_bijection(to_validate);
    }

    NodeId JoinOrderGraph::construct_reorder(QueryEval::NodeId from, std::vector<PositionMerge> &joined,
                                                std::vector<PositionForward> &forwarded, bool is_left,
                                                ll forward_offset, std::unordered_map<ll, ll> *re_reorder /*flags if syntcheck can check for arbitrary end order*/) { //TODO: cleanup passed pars;
        reorder_nodes.emplace_back();
        auto r_id = ReorderId(reorder_nodes.size()-1);
        auto &reorder_node = reorder_nodes.back();
        auto &from_node = get(from);

        assert(!is_left || !forward_offset);
        reorder_node.arr_id = arr_id_count++;
        reorder_node.from = from;
        from_node.edges.push_back(r_id);

        reorder_node.merge_node_depth = from_node.merge_node_depth;
        reorder_node.is_static = from_node.is_static;

        ll pos = 0;
        for (auto &info : joined) {
            assert(pos == info.to);
            reorder_node.re_order.push_back({is_left ? info.from_left : info.from_right, pos});
            if (is_left) info.from_left = pos;
            if (!is_left) info.from_right = pos;
            pos++;
        }

        for (auto &info : forwarded) {
            reorder_node.re_order.push_back({info.from, pos});
            info.from = pos++;
        }

        assert(reorder_node.re_order.size() == joined.size()+forwarded.size());
        assert(get_pos_size(from) >= get_pos_size(r_id));
        validate_bijection(reorder_node.re_order, forward_offset, is_left);

        if (enable_syntactic_query_match) {
            NodeId match = NO_NODE;

            if (re_reorder) {
                std::vector<PositionForward> j_set;
                create_j_pfw(j_set, reorder_node.re_order, joined);
                AdaptiveReorderHash h(from, forwarded, j_set);
                if (adaptive_reorder_matches.contains(h)) {
                    match = adaptive_reorder_matches.at(h);
                    assert(match.is_reorder());
                    verify_reorder(match, r_id, is_left, joined);

#ifdef JOG_DEBUG_FLAG_PRINT_NODE_CACHE_HIT_TYPE
                    std::cout << "Cache hit: reorder (adaptive)" << std::endl;
#endif

                    auto &m_reorder = static_cast<ReOrderNode&>(get(match));
                    determine_re_reorder(*re_reorder, reorder_node.re_order, m_reorder.re_order);
                    assert(re_reorder->size() == m_reorder.re_order.size());
                    assert(m_reorder.re_order.size() == reorder_node.re_order.size());
                    validate_bijection(*re_reorder, true);
#ifdef DEBUG_FLAG_PRINT_REORDER_CACHE_HIT
                    std::cout << "Adaptive reorder match for " << std::endl;
                    dump_propositional_repr(r_id);
                    std::cout << std::endl << "and (match) " << std::endl;
                    dump_propositional_repr(r_id);
                    std::cout << std::endl << "re-reorder is: {";
                    for (auto &[from, to] : *re_reorder) {
                        std::cout << from << " -> " << to << ", ";
                    }
                    std::cout << "}" << std::endl << std::endl ;
#endif
#ifndef NDEBUG
                    for (auto &m_rule : joined) {
                        assert(re_reorder->contains(m_rule.to));
                        assert(re_reorder->at(m_rule.to) == m_rule.to);
                    }
#endif
                }
            } else if (reorder_matches.contains(from)) {
                if (reorder_matches.at(from).contains(reorder_node.re_order)) {
                    match = reorder_matches.at(from).at(reorder_node.re_order);
#ifdef JOG_DEBUG_FLAG_PRINT_NODE_CACHE_HIT_TYPE
                    std::cout << "Cache hit: reorder (static)" << std::endl;
#endif
                }
            }

            if (match != NO_NODE) {
                verify_reorder(match, r_id, is_left, joined);
                reorder_nodes.pop_back();
                from_node.edges.pop_back();
                arr_id_count--;

                validate_bijection(static_cast<ReOrderNode&>(get(match)).re_order, forward_offset, is_left);
#ifndef NDEBUG
                get(static_cast<ReOrderNode&>(get(match)).from); // check that id for .from is properly set
#endif
                return match;
            } else {
                if (!reorder_matches.contains(from)) {
                    reorder_matches.emplace(from, std::unordered_map<std::vector<PositionForward>, NodeId>());
                }

                reorder_matches.at(from).emplace(reorder_node.re_order, r_id);

                std::vector<PositionForward> j_set;
                create_j_pfw(j_set, reorder_node.re_order, joined);
                AdaptiveReorderHash h(from, forwarded, j_set);
                adaptive_reorder_matches.emplace(h, r_id);
            }
        }

#ifndef NDEBUG
        get(static_cast<ReOrderNode&>(get(r_id)).from); // check that id for .from is properly set
#endif
        return r_id; //TODO: combine with others
    }

    void JoinOrderGraph::reorder_joins(std::vector<PositionMerge> &join_rules,
                                       std::vector<PositionForward> &left_vars_to_forward,
                                       std::vector<PositionForward> &right_vars_to_forward,
                                       std::unordered_map<ll, ll> &var_to_pos) { //TODO: it would be a lot more consistent to not compute this here but  bottom up (var to pos from l, r)
        vector<ll> pos_remap(join_rules.size() + left_vars_to_forward.size() + right_vars_to_forward.size());
        ll current_pos = 0;

        //TODO: combine below?
        for (auto &info : join_rules) {
            pos_remap[info.to] = current_pos;
            info.to = current_pos++;
        }
        for (auto &info : left_vars_to_forward) {
            pos_remap[info.to] = current_pos;
            info.to = current_pos++;
        }
        for (auto &info : right_vars_to_forward) {
            pos_remap[info.to] = current_pos;
            info.to = current_pos++;
        }

        for (auto &m : var_to_pos) {
            m.second = pos_remap[m.second];
        }
    }

    void JoinOrderGraph::create_and_mark_result(NodeId last_node, Parameters &result_pars, std::unordered_map<ll, ll> &old_var_to_pos) {
        auto &n = get(last_node);
        std::unordered_map<ll, ll> var_to_pos;
        std::vector<PositionMerge> no_join;
        std::vector<PositionForward> project;
        ll pos = 0;
        for (auto &par : result_pars) {
            var_to_pos.emplace(par, pos);
            project.push_back({old_var_to_pos[par], pos++});
        }

        // TODO important: only if needed;
        std::unordered_map<ll, ll> re_reorder;
        NodeId new_last = construct_reorder(last_node, no_join, project, true, 0, &re_reorder); //TODO: maybe wrap this as construct_project
        if (!re_reorder.empty()) {
            adjust_var_to_pos(var_to_pos, re_reorder);
        }
                                                                                                
        mark_result(next_req_id(), var_to_pos, new_last);
    }

    void JoinOrderGraph::mark_result(ll request_id, unordered_map<ll, ll> &var_to_pos, NodeId last_node) {
        last_request = request_id;
        requests.emplace(request_id, make_pair(var_to_pos, last_node));
    }

    ll JoinOrderGraph::get_pos_size(QueryEval::NodeId n_id) {
        if (n_id.is_init()) { //TODO: make visitor
            auto &init = static_cast<InitNode&>(get(n_id));
            return init.initializer->get_init_size();
        } else if (n_id.is_merge()) {
            auto &merge = static_cast<MergeNode&>(get(n_id));
            return merge.left_positions_forward.size()
                 + merge.right_positions_forward.size()
                 + merge.joined_positions.size();
        } else {
            assert(n_id.is_reorder());
            auto &reorder = static_cast<ReOrderNode&>(get(n_id));
            return reorder.re_order.size();
        }
    }

    void JoinOrderGraph::mark_r_negated(NodeId id) {
        assert(id.is_merge());
        MergeNode &node = static_cast<MergeNode&>(get(id));
        node.right_negated = true;
    }

    ll create_copy(std::vector<Table> &hacky_table_cache, Table &table) {
        ll id = hacky_table_cache.size();
        hacky_table_cache.emplace_back();
        hacky_table_cache.back() = table;
        return id;
    }

    void filter_downwards_left(Table &lower_table, Table &upper_table,
                               std::vector<PositionForward> &l_forward,
                               std::vector<PositionMerge> &join_rules) {
        Table result_table;
        std::vector<PositionMerge> new_join_rules;
        std::vector<PositionForward> new_l_forward;
        std::vector<PositionForward> new_r_forward;

        assert(!lower_table.empty());
        std::vector<bool> seen(lower_table.begin()->size(), false);
        for (auto &el : l_forward) {
            new_join_rules.push_back({el.from, el.to, el.from});
            seen[el.from] = true;
        }
        for (auto &el : join_rules) {
            new_join_rules.push_back({el.from_left, el.to, el.from_left});
            seen[el.from_left] = true;
        }

        for (ll i = 0; i < seen.size(); i++) {
            if (!seen[i]) {
                new_l_forward.push_back({i, i});
            }
        }

        JoinTable::merge(lower_table, upper_table, result_table, new_join_rules, new_l_forward, new_r_forward);

        assert(lower_table.empty() || result_table.empty() || lower_table.begin()->size() == result_table.begin()->size());
        lower_table = result_table;
    }

    void swap_l_r(Table &from, Table &to,
                  std::vector<PositionForward> &l_forward,
                  std::vector<PositionForward> &r_forward,
                  std::vector<PositionMerge> &join_rules,
                  std::vector<PositionForward> &new_l_forward) {
        std::vector<PositionForward> reorder;
        for (auto &el : join_rules) {
            reorder.push_back({el.to, el.to});
        }
        for (auto &el : r_forward) {
            reorder.push_back({el.to, static_cast<ll>(el.to-l_forward.size())});
            new_l_forward.push_back({el.to, static_cast<ll>(el.to-l_forward.size())});
        }
        for (auto &el : l_forward) {
            reorder.push_back({el.to, static_cast<ll>(el.to+r_forward.size())});
        }

        JoinTable::reorder(from, to, reorder);
        assert(from.size() == to.size());
    }

    void filter_downwards_right(Table &lower_table, Table &upper_table,
                                std::vector<PositionForward> &l_forward,
                                std::vector<PositionForward> &r_forward,
                                std::vector<PositionMerge> &join_rules) {
        Table new_upper_table;
        std::vector<PositionForward> new_l_forward;
        swap_l_r(upper_table, new_upper_table, l_forward, r_forward, join_rules, new_l_forward);

        filter_downwards_left(lower_table, new_upper_table, new_l_forward, join_rules);
    }

    void filter_downwards_reorder(Table &lower_table, Table &upper_table,
                                  std::vector<PositionForward> &reorder) {
        std::vector<PositionMerge> merge;
        filter_downwards_left(lower_table, upper_table, reorder, merge);
    }

    // TODO: rename
    NodeId JoinOrderGraph::mark_head_positions_forward(NodeId node,
                                                      ll node_table_id, // new table for current node
                                                      TableCache &table_cache, // global table cache
                                                      std::vector<Table> &hacky_table_cache, // local table cache
                                                      bool &worked,
                                                      JoinOrderGraph &flat_jog,
                                                      std::unordered_map<NodeId, std::vector<InitColId>> &cache_entries_as_init_col_ids,
                                                      std::vector<NodeId> &variable_renaming,
                                                      InitColLookup &lookup) { //global exploration flag

        auto &n_table = hacky_table_cache[node_table_id];
        if (!worked) {
            return NO_NODE;
        }

        if (n_table.empty()) {
            worked = false;
            return NO_NODE;
        }

        if (node.is_init()) { //TODO: make visitor
            // create node
            auto &init_node = static_cast<InitNode&>(get(node));
            std::vector<ll> standard_reorder;
            for (ll i = 0; i < init_node.initializer->rev_pos_order.size(); i++) {
                standard_reorder.push_back(i);
            }
            NodeId new_node = flat_jog.create_new_predicate_initializer(variable_renaming.size(), standard_reorder, NO_INFO);

            // copy reduced tablea
            assert(!cache_entries_as_init_col_ids.contains(new_node));
            cache_entries_as_init_col_ids.emplace(new_node, std::vector<InitColId>());
            auto &mapping_to_fill = cache_entries_as_init_col_ids.at(new_node);
            auto predicate = init_node.initializer->predicate;

            for (auto &row : n_table) {
                mapping_to_fill.emplace_back(lookup.look_up(predicate, row));
            }

            // mark
            variable_renaming.push_back(new_node);

            return new_node;
        } else if (node.is_merge()) {
            auto &merge_node = static_cast<MergeNode&>(get(node));
            auto l_table_id = create_copy(hacky_table_cache, table_cache.get_node_table(get(merge_node.left).arr_id));
            auto r_table_id = create_copy(hacky_table_cache, table_cache.get_node_table(get(merge_node.right).arr_id));

            filter_downwards_left(hacky_table_cache[l_table_id], hacky_table_cache[node_table_id], merge_node.left_positions_forward, merge_node.joined_positions);
            NodeId left_node = mark_head_positions_forward(merge_node.left, l_table_id, table_cache, hacky_table_cache, worked, flat_jog, cache_entries_as_init_col_ids, variable_renaming, lookup);
            if (!worked) return NO_NODE;

            filter_downwards_right(hacky_table_cache[r_table_id], hacky_table_cache[node_table_id], merge_node.left_positions_forward, merge_node.right_positions_forward, merge_node.joined_positions);
            NodeId right_node = mark_head_positions_forward(merge_node.right, r_table_id, table_cache, hacky_table_cache, worked, flat_jog, cache_entries_as_init_col_ids, variable_renaming, lookup);
            if (!worked) return NO_NODE;

            return flat_jog.create_join_node(left_node, right_node, merge_node.left_positions_forward, merge_node.right_positions_forward, merge_node.joined_positions, nullptr, nullptr, nullptr);

        } else if (node.is_reorder()) { //TODO: combine merge and reorder?
            auto &reorder_node = static_cast<ReOrderNode&>(get(node));
            auto table_id = create_copy(hacky_table_cache, table_cache.get_node_table(get(reorder_node.from).arr_id));

            filter_downwards_reorder(hacky_table_cache[table_id], hacky_table_cache[node_table_id], reorder_node.re_order);
            NodeId last_node = mark_head_positions_forward(reorder_node.from, table_id, table_cache, hacky_table_cache, worked, flat_jog, cache_entries_as_init_col_ids, variable_renaming, lookup);
            if (!worked) return NO_NODE;

            // construct node
            std::vector<PositionMerge> no_join;
            return flat_jog.construct_reorder(last_node, no_join, reorder_node.re_order, true, 0, nullptr); //TODO: maybe wrap this as construct_project, combine with create and mark_result
        } else {
            assert(false && "shouldn't happen");
            return NO_NODE;
        }

    }

    // TODO: rename unique to extract_reduced_flat_jog_from_this
    void JoinOrderGraph::verify_binary(HELP::QueryEval::NodeId end) {
        // check binary tree, unique predicates
        assert(false);
    }

    NodeId JoinOrderGraph::extract_reduced_flat_jog_from_this(JoinOrderGraph &flat_jog,
                                                            NodeId node,
                                                            std::unordered_map<NodeId, std::vector<InitColId>> &cache_entries_as_init_col_ids,
                                                            TableCache &cache,
                                                            std::vector<NodeId> &variable_renaming,
                                                            InitColLookup &lookup) {
        std::vector<Table> hacky_table_cache; //TODO: typing (unique ptr?)
        auto &initial_table = cache.get_node_table(get(node).arr_id);
        assert(!initial_table.empty());
        hacky_table_cache.push_back(initial_table);
        bool worked = true;
        NodeId end = mark_head_positions_forward(node,
                                    0,
                                    cache,
                                    hacky_table_cache,
                                    worked,
                                    flat_jog,
                                    cache_entries_as_init_col_ids,
                                    variable_renaming,
                                    lookup);

#ifndef NDEBUG
        flat_jog.verify_binary(end);
#endif

        return end;
    }

    enum InitColEntryStatus {
        UNUSED,
        INSERTED,
        MATCHED
    };

    class InitColEntryStatusRegistry {
        std::unordered_map<InitColId, InitColEntryStatus> status_list;

    public:
        InitColEntryStatusRegistry() {
            assert(false && "TODO implement me");
        }
    };

    ll compute_total_matchable_atoms(std::unordered_map<NodeId, std::vector<InitColId>> entry_map) {
        std::unordered_set<InitColId> seen;

        for (auto &[_, v]: entry_map) {
            for (auto &entry : v) {
                seen.insert(entry);
            }
        }

        return seen.size();
    }
    
    static bool worth_inserting() {
        assert(false && "TODO implement me");
        return true;
    }
    
    static void insert_match_nodes_according_to_failed_nodes() {
        assert(false && "TODO implement me");
    }

    // TODO: return type can be removed
    // TODO: maybe there is a smart way to determine valid or reduced matches
    // TODO: important this seems to use far too many upwards/downwards pass combinations
    void JoinOrderGraph::try_match(NodeId node, std::vector<InitCollection> &result,
                                   TableCache &cache, ll match_bound, InitColLookup &lookup) {
        /*
         * This idea was abandoned for now. The idea was to insert atoms to tables until we can extract
         * a variable mapping. And the maybe continue inserting until the extracted result exceed the match_bound
         *
         * The idea was to prefer atom insertions in the following way:
         *  - Never inserted into any atom table
         *  - Not matched, but inserted in another table
         *  - Matched already (no other distinction)
         */

        JoinOrderGraph flat_jog(db_info_copy);
        std::unordered_map<NodeId, std::vector<InitColId>> cache_entries_as_init_col_ids;
        std::vector<NodeId> variable_renaming;
        // the jog will corespond to a jog where each node has one outgoing edge (except for the last node)
        // the table cache will correspond to a downwards reduced version of cache
        NodeId last_node = extract_reduced_flat_jog_from_this(flat_jog, node, cache_entries_as_init_col_ids, cache, variable_renaming, lookup);

        if (last_node == NO_NODE) {
            return;
        }

        InitColEntryStatusRegistry status_registry;
        DeltaTableCache table_cache = flat_jog.create_delta_table_cache_simple(NO_INFO);
        auto total_matchable_atoms = compute_total_matchable_atoms(cache_entries_as_init_col_ids);
        SimplePredInitializerWrapManager simple_start_node_manager(flat_jog.create_simple_start_node_manager());
        InitCollection delta_state;

        while (worth_inserting()) {
            assert(false && "reintroduce evaluate for delta computation");
            //flat_jog.evaluate(delta_state, table_cache, simple_start_node_manager, NO_INFO);
            std::unordered_map<QueryEval::NodeId, std::vector<ll>> failing_nodes;
            flat_jog.extract_fail_nodes(table_cache.get_accumulated_tables(), last_node, failing_nodes);

            insert_match_nodes_according_to_failed_nodes();
        }
    }

    void increase_amount(ll var, std::map<ll, ll> &init_table_amounts) {
        if (!init_table_amounts.contains(var)) {
            init_table_amounts.emplace(var, 0);
        }
        init_table_amounts.at(var)++;
    }

    void insert_vec(std::vector<ll> &v, std::map<ll, ll> &init_table_amounts) {
        set<ll> vars(v.begin(), v.end()); //TODO: unordered?
        for (ll var : vars) {
            increase_amount(var, init_table_amounts);
        }
    }

    void count_init_table_amounts(std::map<ll, ll> &init_table_amounts, InitCollection &init_collection) {
        for (auto &m : init_collection.predicate_init) {
            for (auto &v : m.second) {
                insert_vec(v, init_table_amounts);
            }
        }
    }

    void reduce_i_collection(InitCollection &init_collection, InitCollection &partial_collection) {
        std::vector<ll> keys_to_erase;

        for (auto &m : init_collection.predicate_init) {
            if (partial_collection.predicate_init.contains(m.first)) {
                std::set<std::vector<ll>> eq_s(m.second.begin(), m.second.end()); //TODO: important, count combined
                for (auto &v: partial_collection.predicate_init.at(m.first)) {
                    eq_s.erase(v);
                }
                m.second = std::vector<std::vector<ll>>(eq_s.begin(), eq_s.end());
            }
            if  (m.second.empty()) {
                keys_to_erase.push_back(m.first);
            }
        }

        for (ll key : keys_to_erase) {
            init_collection.predicate_init.erase(key);
        }
    }

    void insert_artificial_predicate(InitCollection &init_collection, ll artificial_predicate, const Row &row) {
        assert(!init_collection.predicate_init.contains(artificial_predicate));
        init_collection.predicate_init.emplace(artificial_predicate, std::vector<std::vector<ll>>{row});
    }

    void extend_db_info(DBInfo &info, ll artificial_predicate_am) { // TODO: (important) at some point we should come up with reasonable values here to also benefit from query ordering for merged parts
        for (ll i = -1; i > artificial_predicate_am; i--) {
            info.most_duplicated.emplace(i, 0);
            info.init_table_size.emplace(i, 0);
        }
    }

    void JoinOrderGraph::add_new_query(Query &query, DBInfo &info) {
        //normalize query
        auto jo = create_join_order_and_annotate(query);
        JoinOrderGraph other(query, jo, info);
        auto top_node = other.get_last_request_node();
        std::vector<ll> new_result_pars; //TODO: can just determine as 0,...,|old_pars|
        InitCollection init_collection;
        other.collect_atoms(init_collection, top_node, new_result_pars); //TODO: important TODO important cache collected atoms

        auto &var_pos_map = other.get_last_var_map();
        std::unordered_map<ll,ll> old_to_new;
        for (auto &[var, pos] : var_pos_map) {
            assert(pos < new_result_pars.size());
            old_to_new.emplace(new_result_pars[pos], var);
        }

        add_new_query(init_collection, new_result_pars, old_to_new, info);
    }

    // TODO: remove static, move
    static inline ll count_entries(InitCollection &init_collection) {
        ll count = 0;
        for (auto &[p, v] : init_collection.predicate_init) {
            count += v.size();
        }
        return count;
    }

    void JoinOrderGraph::add_new_query(InitCollection &init_collection, std::vector<ll> &new_result_pars, std::unordered_map<ll,ll> &old_to_new, DBInfo &info) {
        ll artificial_predicate = -1; //TODO: can we do soemthing else than -1 hack?
        std::map<ll, NodeId> predicate_to_node; //TODO: should be vec

#ifdef JOG_DEBUG_FLAG_PRINT_HEAD_MATCH_AMOUNT
        std::cout << "start matching" << std::endl;
#endif

        if (enable_semantic_query_match) {
            DBInfo &old_info_ref = info;
            DBInfo info;
            info.predicate_amount = old_info_ref.predicate_amount;
            TableCache cache(create_table_cache_simple(info));

            std::vector<NodeId> last_nodes;
            SimplePredInitializerWrapManager start_nodes(create_simple_start_node_manager());
            evaluate(init_collection, cache, start_nodes, info, &last_nodes);

            std::unordered_set<NodeId> seen_vnodes;
            std::vector<NodeId> valid_last_nodes;
            for (auto node: last_nodes) { //TODO important: could cache and reuse old invalid nodes
                insert_valid_nodes(node, valid_last_nodes,
                                   seen_vnodes, cache); //TODO: could add different criteria, explain what is the current criterion (static chain unbroken)
            }

            //TODO: unique elements;

#ifdef JOG_DEBUG_FLAG_PRINT_MATCHES_FOUND
            std::cout << "Matches for " << std::endl;
            print_init_collection(init_collection);
            std::cout << std::endl << "are" << std::endl;

            for (auto node : valid_last_nodes) {
                InitCollection atoms_underlying;
                std::vector<ll> ignore;
                std::cout << "node id: (" << node.get_enum_val() << ", " << node.id_num << ")" << std::endl;
                collect_atoms(atoms_underlying, QueryEval::NO_NODE, ignore, &node);
                print_init_collection(atoms_underlying);
                std::cout << std::endl;
            }
            std::cout << std::endl;
#endif

            InitColLookup lookup(init_collection);
            ll match_bound = count_entries(init_collection) * MATCH_BOUND_FACTOR;
            for (auto last_node : valid_last_nodes) {
                std::vector<InitCollection> partial_collections(1); //TODO: maybe resize inside try match?
                try_match(last_node, partial_collections, cache, match_bound, lookup);

#ifdef JOG_DEBUG_FLAG_PRINT_TRY_MATCH_RESULTS
                std::cout << "try match result for node id: (" << last_node.get_enum_val() << ", " << last_node.id_num << ")" << std::endl;
                for (auto &partial_collection : partial_collections) {
                    print_init_collection(partial_collection);
                    std::cout << std::endl;
                }
                if (partial_collections.empty()) {
                    std::cout << "(empty)" << std::endl;
                }
#endif
            }
        }

        // build rest //TODO: wrap below into functions

        //TODO important: this does not consider negations at any point and time

        std::vector<Atom> new_atoms;
        for (auto &m : init_collection.predicate_init) {
            for (auto &pars : m.second) {
                std::vector<ParameterOrObject> args;
                for (auto par : pars) {
                    args.emplace_back(true, par);
                }
                new_atoms.emplace_back(m.first, args);
            }
        }

        DBInfo new_info = info;
        extend_db_info(new_info, artificial_predicate);
        Query new_query(new_atoms, new_result_pars, new_info);
        auto new_join_order = create_join_order_and_annotate(new_query);
        build_simple(new_query, new_join_order, info, &predicate_to_node);
        adjust_pars(get_last_request(), old_to_new);
    }

    void JoinOrderGraph::adjust_pars(ll request, std::unordered_map<ll,ll> &old_to_new) {
        auto &original_map = requests.at(request).first;
        std::unordered_map<ll,ll> new_map;
        for (auto &[old_var, pos] : original_map) {
            assert(old_to_new.contains(old_var));
            new_map.emplace(old_to_new[old_var], pos);
        }
        requests[request].first = new_map;
    }

    struct NodeSortStruct {
        NodeId id;
        JoinGraphNode *node;
    };

    void JoinOrderGraph::sort_by_length_decr(vector<NodeId> &nodes) {
        std::vector<NodeSortStruct> sortable;
        for (auto node : nodes) {
            sortable.push_back({node, &get(node)});
        }

        std::sort(sortable.begin(), sortable.end(), [](const NodeSortStruct& lhs, const NodeSortStruct& rhs) {
            return lhs.node->merge_node_depth > rhs.node->merge_node_depth;
        });

        nodes.clear();
        for (auto &s : sortable) {
            nodes.push_back(s.id);
        }
    }

    bool JoinOrderGraph::is_valid_root(NodeId node) {
        if (node.is_init()) { //TODO: make visitor
            return false;
        } else if (node.is_merge()) {
            return true; //TODO: important detect broken chains
        } else if (node.is_reorder()) {
            return false; //TODO: important detect broken chains
        } else {
            assert(false && "shouldn't happen");
        }
    }

    void JoinOrderGraph::insert_valid_nodes(NodeId node, vector<NodeId> &valid_last_nodes, std::unordered_set<NodeId> &seen, TableCache &cache) { //TODO: could combine this by get predecessor or just templatize
        if (seen.contains(node)) {
            return;
        }
        seen.insert(node);

        if (cache.get_node_table(get(node).arr_id).empty()) {
            if (node.is_init()) {  // TODO: make visitor
                // nothing
            } else if (node.is_merge()) {
                auto &merge_node = static_cast<MergeNode &>(get(node));
                insert_valid_nodes(merge_node.left, valid_last_nodes, seen, cache);
                insert_valid_nodes(merge_node.right, valid_last_nodes, seen, cache);
            } else if (node.is_reorder()) {
                auto &reorder_node = static_cast<ReOrderNode &>(get(node));
                insert_valid_nodes(reorder_node.from, valid_last_nodes, seen, cache);
            } else {
                assert(false && "shouldn't happen");
            }
        } else {
            if (is_valid_root(node)) {
                valid_last_nodes.push_back(node);
            } else {
                if (node.is_init()) {  // TODO: make visitor
                    // nothing
                }
                else if (node.is_merge()) {
                    // nothing
                }
                else if (node.is_reorder()) {
                    auto &reorder_node = static_cast<ReOrderNode &>(get(node));
                    insert_valid_nodes(reorder_node.from, valid_last_nodes, seen, cache);
                }
                else {
                    assert(false && "shouldn't happen");
                }
            }
        }
    }

    bool JoinOrderGraph::fully_explored(NodeId _node, TableCache &cache) {
        auto arr_id = get(_node).arr_id;
        auto amount = cache.get_pre_f().at(arr_id);
        if (_node.is_init()) {
            assert(amount == 0);
            return true;
        } else if (_node.is_merge()) {
            assert(amount <= 2);
            return amount == 2;
        } else if (_node.is_reorder()) {
            assert(amount <= 1);
            return amount == 1;
        } else {
            assert(false && "shouldn't happen");
        }
    }

    void JoinOrderGraph::adjust_pre_f(TableCache &cache, NodeId id, std::queue<NodeId> &q) { // TODO: this should not happen here but when pre_f is extended
        assert(!id.is_init());

        if (id.is_reorder()) {
            auto &reorder_node = static_cast<ReOrderNode&>(get(id));

            int val = !cache.get_node_table(get(reorder_node.from).arr_id).empty();
            cache.get_pre_f().at(arr_get(id)) = val;

            if (val == 1) {
                q.push(id);
            }
        } else if (id.is_merge()) {
            auto &merge_node = static_cast<MergeNode&>(get(id));

            int val = !cache.get_node_table(get(merge_node.left).arr_id).empty()
                      + !cache.get_node_table(get(merge_node.right).arr_id).empty();
            cache.get_pre_f().at(arr_get(id)) = val;

            if (val == 2) {
                q.push(id);
            }
        } else {
            assert(false && "shouldn't happen");
        }
    }

    JoinOrderGraph::JoinOrderGraph(DBInfo &info)
        : db_info_copy(info)
    {}
}

}