#ifndef HELP_CORE_INIT_NODES_H
#define HELP_CORE_INIT_NODES_H

#include <memory>
#include <map>
#include <unordered_map>
#include <boost/variant.hpp>
#include "../../task_formulations/db_propositional_shared.h"
#include "../table_representation/table.h"

namespace HELP { 

namespace QueryEval {
    struct InitCollection { // TODO: rm what now acts as wrapper
        std::unordered_map<ll, std::vector<std::vector<ll>>> predicate_init; // maps predicate to var collection //TODO: "should" be triple vec, init size in beginning
    };

    //TODO: all public attributes are weird

    //TODO: make this a templatized util
    inline std::vector<ll> rev_vec(std::vector<ll> v) { //TODO: void
        std::vector<ll> new_v(v.size());

        for (ll i = 0; i < v.size(); i++) {
            assert(v[i] < v.size());
            new_v[v[i]] = i;
        }

        return new_v;
    }

    class PredicateInitializer {
    public:
        ll predicate;
        std::vector<ll> pos_order;
        std::vector<ll> rev_pos_order;
        PredicateInitializer(ll predicate, std::vector<ll> &pos_order) : predicate(predicate), pos_order(pos_order), rev_pos_order(rev_vec(pos_order)) { }
        void init(JoinTable::Table &table, GroundAtomCol &state, const DBInfo &db_Info);
        void init(JoinTable::Table &table, InitCollection &atom_var_maps, const DBInfo &db_Info);
        void add_to_init(std::vector<ll> &pos_to_var, InitCollection &init_collection);
        ll get_init_size();
    };

    struct InitNode : public JoinGraphNode {
        std::shared_ptr<PredicateInitializer> initializer; //TODO: np pointer, directly init predicate, this is still from legacy distinction
        InitNode(std::shared_ptr<PredicateInitializer> initializer) : initializer(initializer) {}
    };

    inline InitNode PredicateInit(ll predicate, std::vector<ll> &pos_order, ll id, DBInfo &info) {
        InitNode init_node(std::make_shared<PredicateInitializer>(predicate, pos_order));
        init_node.arr_id = id;
        init_node.is_static = info.static_predicates.contains(predicate);
        return init_node;
    }
}

}


#endif //HELP_CORE_INIT_NODES_H
