#include "init_nodes.h"
#include "../join_and_project.h"

namespace HELP { 

namespace QueryEval {
    void PredicateInitializer::init(QueryEval::JoinTable::Table &table, GroundAtomCol &state, const DBInfo &db_Info) { //TODO important TODO: imporant should have a lookup per predicate (pre arranged into tables)
        for (auto &atom : state.get_atoms(predicate)) {
            JoinTable::Row reordered_row(pos_order.size());
            assert(atom.get_args().size() == pos_order.size());
            for (ll i = 0; i < pos_order.size(); i++) {
                reordered_row[pos_order[i]] = atom.get_args()[i];
            }
            table.insert(reordered_row);
        }
    }

    ll PredicateInitializer::get_init_size() {
        return pos_order.size();
    }

    void PredicateInitializer::add_to_init(std::vector<ll> &pos_to_var, InitCollection &init_collection) {
        if (!init_collection.predicate_init.contains(predicate)) {
            init_collection.predicate_init.emplace(predicate, std::vector<std::vector<ll>>());
        }

        std::vector<ll> normalized_pos_to_var(pos_to_var.size());
        for (ll i = 0; i < pos_to_var.size(); i++) {
            normalized_pos_to_var[rev_pos_order[i]] = pos_to_var[i];
        }

        init_collection.predicate_init.at(predicate).push_back(normalized_pos_to_var);
    }

    void PredicateInitializer::init(JoinTable::Table &table, InitCollection &atom_var_maps, const DBInfo &db_Info) {
        if (atom_var_maps.predicate_init.contains(predicate)) {
            for (auto &v_map: atom_var_maps.predicate_init.at(predicate)) {
                std::vector<ll> reordered_row(v_map.size());
                for (ll i = 0; i < v_map.size(); i++) {
                    reordered_row[pos_order[i]] = v_map[i];
                }

                table.insert(reordered_row);
            }
        }
    }
}

}