#ifndef HELP_CORE_CRITERION_GENERATOR_H
#define HELP_CORE_CRITERION_GENERATOR_H

#include "criterion.h"
#include "yannakakis.h"
#include "random.h"
#include "crit_enum.h"
#include "first.h"

namespace HELP { 

namespace QueryEval {
    template<typename add_info_t, JoinCriterionName criterion>
    constexpr JoinCriterion<add_info_t> *to_join_crit(add_info_t &removed_lookup) { //TODO rn
        switch (criterion) {
            case YANNAKAKIS:
                return new YannakakisCrit<add_info_t>(removed_lookup);
            case RANDOM:
                return new RandomCrit<add_info_t>(removed_lookup);
            case FIRST:
                return new FirstCrit<add_info_t>(removed_lookup);
            default:
                return nullptr; //TODO: is this smart?
        }
    }
}

}

#endif //HELP_CORE_CRITERION_GENERATOR_H
