#ifndef HELP_CORE_CRITERION_H
#define HELP_CORE_CRITERION_H

#include "../../join_and_project.h"
#include "additional_info.h"

namespace HELP { 

namespace QueryEval {
    struct PotentitalJoinElementFound {
        bool found;
        JoinOrderElement element;
    };

    //TODO: we probably only want to define join criterion here and create a generalized class for the
    //TODO: template stuff in utils

    template<typename add_info_t>
    class JoinCriterion {
    protected:
        add_info_t &add_info;
        void add_annotated(std::set<ParRef> &to, ll atom_id) { //TODO: should this really be here?
            AnnotatedPars &annotated = add_info;
            for (auto par : annotated[atom_id]) {
                to.insert(par);
            }
        }
    public:
        JoinCriterion(add_info_t &add_info) : add_info(add_info) {}
        virtual ~JoinCriterion() = default;

        virtual PotentitalJoinElementFound
        try_get(QueryEval::Query &query) = 0; //TODO: is there a smarter way that can store things immediately?
    };
}

}

#endif //HELP_CORE_CRITERION_H
