#ifndef HELP_CORE_ADDITIONAL_INFO_H
#define HELP_CORE_ADDITIONAL_INFO_H

#include "crit_enum.h"
#include <vector>
#include <cassert>
#include <set>

namespace HELP { 

//TODO: maybe we should place this into joinbycriterion

namespace QueryEval {
    //TODO: a lot of this should be handled by macros/template, boost reflectable may be the right choice
    //TODO: may create an additional namespace

    class RemovedAtoms : public std::vector<bool> {};
    class EdgeCount : public std::vector<ll> {
    public:
        void increase(ParRef par_ref) { //TODO proper type
            while (size() <= par_ref) { //TODO: use util function instead
                push_back(0);
            }
            at(par_ref)++;
        }
        void decrease(ParRef par_ref) { //TODO proper type
            at(par_ref)--;
        }
    };
    class UniquePars : public std::set<ParRef> {};
    class AnnotatedPars : public std::vector<std::set<ParRef>> {};

    template<JoinCriterionName ...criteria>
    struct concrete_add_info {
        RemovedAtoms removed;
        AnnotatedPars annotated;
        EdgeCount edge_count; //TODO: only add conditionally
        UniquePars unique_pars; //TODO: only add conditionally

        //TODO: are these operators still needed?
        operator RemovedAtoms &() {
            return removed;
        }

        operator EdgeCount &() {
            return edge_count;
        }

        operator UniquePars &() {
            return unique_pars;
        }

        operator AnnotatedPars &() {
            return annotated;
        }
    };
}

}

#endif //HELP_CORE_ADDITIONAL_INFO_H
