#include "join_by_criterion.h"

namespace HELP { 

namespace QueryEval {
    template<JoinCriterionName... criteria_names>
    JoinOrder JoinByCriterion<criteria_names...>::generate(Query &query) {
        JoinOrder join_order; //TODO: maybe, this should be part of info
        new_query(query);

        while (join_order.size()+1 < query.size()) {
            for (auto *crit : criteria) {
                auto res = crit->try_get(query);
                if (res.found) {
                    assert(res.element.from_id != res.element.to_id);
                    assert(res.element.from_id != -1);
                    assert(res.element.to_id != -1);
                    join_order.push_back(res.element); //TODO: maybe, this should be part of new_edge
                    new_edge(query, res.element);
                    break;
                }
            }
        }

        return join_order;
    }

    template<JoinCriterionName... criteria_names>
    void JoinByCriterion<criteria_names...>::new_query(Query &query) {
        reset(add_info.removed, query);
        reset(add_info.edge_count, query);
        reset(add_info.unique_pars, query);
        reset(add_info.annotated, query);
    }

    template<JoinCriterionName... criteria_names>
    void JoinByCriterion<criteria_names...>::new_edge(Query &query, JoinOrderElement &edge) {
#ifndef NDEBUG
        count_updated = false;
#endif
        update(query, add_info.removed, edge);
        update(query, add_info.edge_count, edge);
        update(query, add_info.unique_pars, edge);
        update(query, add_info.annotated, edge);
    }

    //TODO: maybe use this to do this generatively: https://buildingblock.ai/reflection
    template<JoinCriterionName... criteria_names>
    void JoinByCriterion<criteria_names...>::reset(RemovedAtoms &removed, Query &query) {
        removed = {std::vector<bool>(query.size(), false)}; //TODO: is this the best way to this?
    }

    template<JoinCriterionName... criteria_names>
    void JoinByCriterion<criteria_names...>::reset(EdgeCount &edge_count, Query &query) {
#ifndef NDEBUG
        count_reset = true;
#endif
        edge_count.clear();
        for (ll i = 0; i < query.get_par_amount(); i++) {
            edge_count.push_back(query.atoms_for(i).size());
        }
    }

    template<JoinCriterionName... criteria_names>
    void JoinByCriterion<criteria_names...>::reset(AnnotatedPars &annotated, Query &query) {
        annotated.clear(); //TODO reset size?
        for (ll i = 0; i < query.size(); i++) { //TODO: could just use inititalizer instead
            annotated.emplace_back();
        }
    }

    template<JoinCriterionName... criteria_names>
    void JoinByCriterion<criteria_names...>::reset(UniquePars &unique_pars, Query &query) {
#ifndef NDEBUG //TODO: maybe just generalize this to an order over methods
        assert(count_reset);
        count_reset = false;
#endif
        unique_pars.clear();

        EdgeCount &edge_count = add_info;
        for (ll i = 0; i < edge_count.size(); i++) {
            if (edge_count[i] == 1) { //TODO combine check with update?
                unique_pars.insert(i);
            }
        }
    }

    template<JoinCriterionName... criteria_names>
    void JoinByCriterion<criteria_names...>::update(Query &query, RemovedAtoms &removed, JoinOrderElement &edge) {
        removed[edge.from_id] = true;
    }

    template<JoinCriterionName... criteria_names>
    void JoinByCriterion<criteria_names...>::update(Query &query, EdgeCount &edge_count, JoinOrderElement &edge) {
#ifndef NDEBUG
        count_updated = true;
#endif

        for (auto &par : query.get_pars(edge.from_id)) { //TODO: & not needed
            if (edge_count[par] == 1 || query.get_pars(edge.to_id).contains(par)) {
                edge_count.decrease(par); //TODO: it seems to make more sense to perform annotation, unique detection here
            }
        }
    }

    template<JoinCriterionName... criteria_names>
    void JoinByCriterion<criteria_names...>::update(Query &query, UniquePars &unique_pars, JoinOrderElement &edge) {
#ifndef NDEBUG
        assert(count_updated);
#endif

        EdgeCount &edge_count = add_info;
        for (auto &par : query.get_pars(edge.from_id)) { //TODO: & not needed
            if (edge_count[par] == 0) { //TODO combine check with update?
                unique_pars.erase(par);
            } else if (edge_count[par] == 1) {
                unique_pars.insert(par);
            }
        }
    }

    template<JoinCriterionName... criteria_names>
    void JoinByCriterion<criteria_names...>::update(Query &query, AnnotatedPars &annotation, JoinOrderElement &edge) {
#ifndef NDEBUG
        assert(count_updated);
#endif

        EdgeCount &edge_count = add_info;
        for (auto &par : query.get_pars(edge.from_id)) { //TODO: & not needed
            if (edge_count[par] > 0 && !query.get_pars(edge.to_id).contains(par)) { //TODO combine check with edge count update?
                annotation[edge.to_id].insert(par);
            }
        }
    }
}

}