#ifndef HELP_CORE_JOIN_BY_CRITERION_H
#define HELP_CORE_JOIN_BY_CRITERION_H

#include "join_order_generator.h"
#include "join_criteria/criterion_generator.h"
#include "join_criteria/additional_info.h"
#include <array>
#include <initializer_list>

namespace HELP { 

namespace QueryEval {
    template<typename add_info_t>
    using CritCreate = JoinCriterion<add_info_t>* (add_info_t &);

    template <typename add_info_t, JoinCriterionName criterion>
    inline JoinCriterion<add_info_t>* create(add_info_t &removed_lookup) { //TODO: assert is criterion
        return to_join_crit<add_info_t, criterion>(removed_lookup);
    }

    template<typename add_info_t, size_t size> //TODO: is there a nicer way tan passing size manually
    constexpr auto do_create(add_info_t &info, std::initializer_list<CritCreate<add_info_t>*> creators) { //TODO: rename
        std::array<JoinCriterion<add_info_t>*, size> res = {};
        size_t i = 0;
        for (auto *create : creators) {
            res[i] = (*create)(info);
            i++;
        }
        return res;
    }

    template<typename add_info_t, CritCreate<add_info_t>*... creators>
    constexpr auto create_criteria(add_info_t &info) { return do_create<add_info_t, sizeof...(creators)>(info, {creators... }); }

    template<typename add_info_t, JoinCriterionName criterion, CritCreate<add_info_t>*... creators> //TODO: how can we get rid of this and combine with below? --prob  just changing par order
    constexpr auto create_criteria(add_info_t &info) { return create_criteria<add_info_t, creators..., &create<add_info_t, criterion>>(info); }

    template<typename add_info_t, JoinCriterionName criterion, JoinCriterionName... rest_criteria, CritCreate<add_info_t>*... creators>
    constexpr auto create_criteria(add_info_t &info) { return create_criteria<add_info_t, rest_criteria..., creators..., &create<add_info_t, criterion>>(info); }

    template<JoinCriterionName... criteria_names>
    class JoinByCriterion : public JoinOrderGenerator {
        concrete_add_info<criteria_names...> add_info;
        //TODO: typedef for array below
        std::array<JoinCriterion<concrete_add_info<criteria_names...>>*, sizeof...(criteria_names)> criteria = create_criteria<concrete_add_info<criteria_names...>, criteria_names...>(add_info); //TODO const?

#ifndef NDEBUG
        // used to verify that the count is updated before unique pars
        bool count_reset;
        // used to verify that the count is updated before unique pars
        bool count_updated;
#endif

        void new_query(Query &query);
        void new_edge(Query &query, JoinOrderElement &edge);

        void reset(RemovedAtoms &removed, Query &query); //TODO: use template or reflection to enumerate this
        void reset(EdgeCount &edge_count, Query &query);
        void reset(UniquePars &unique_pars, Query &query);
        void reset(AnnotatedPars &unique_pars, Query &query);

        void update(Query &query, RemovedAtoms &removed, JoinOrderElement &edge);
        void update(Query &query, EdgeCount &edge_count, JoinOrderElement &edge);
        void update(Query &query, UniquePars &unique_pars, JoinOrderElement &edge);
        void update(Query &query, AnnotatedPars &unique_pars, JoinOrderElement &edge);

    public:
        JoinOrder generate(Query &query) override;
    };

}

}

#include "join_by_criterion.tpp"

#endif //HELP_CORE_JOIN_BY_CRITERION_H
