#ifndef HELP_CORE_JOIN_AND_PROJECT_H
#define HELP_CORE_JOIN_AND_PROJECT_H

#include "../utils/type_defs.h"
#include "../task_formulations/db_propositional_shared.h"
#include "table_representation/table.h"
#include "query_sort.h"
#include <vector>
#include <set>


namespace HELP { 

namespace QueryEval {

//TODO: adjust collections
//TODO: move to util TODO make sure accepts only int types
template<typename T> //TODO: could probably accept more than vector
std::vector<std::vector<T>> id_reverse(std::vector<std::set<T>> &org_vec) { //TODO: make void
    std::vector<std::vector<T>> res;
    for (ll i = 0; i < org_vec.size(); i++) {
        auto &v = org_vec[i];
        for (T el : v) {
            assert(el >= 0);
            while (res.size() <= el) { //TODO: I seem to like doing this, make it a util function
                res.emplace_back();
            }
            res[el].push_back(i);
        }
    }
    return res;
}

typedef ll AtomRef; //TODO: does this really make sense, do we want to wrap that?

class Query {
    Parameters result_pars;
    std::vector<Atom> atoms; //TODO: const
    std::vector<std::set<ParRef>> pars_per_atom; //TODO: const, make vector, vector
    std::vector<std::vector<AtomRef>> atom_per_pars; //TODO: is this really needed here?
    ll par_amount; //TODO: is max par, could remap if we want to

public:
    std::set<ParRef> &get_pars(ll id) { //TODO: const
        return pars_per_atom[id];
    }

    std::vector<AtomRef> &atoms_for(ParRef id) {
        return atom_per_pars[id];
    }

    Atom &get_atom(ll id) { //TODO: const
        return atoms[id];
    }

    auto size() {
        return atoms.size();
    }

    ll get_par_amount() {
        return par_amount;
    }

    Parameters &get_result_pars() {
        return result_pars;
    }

    Query(std::vector<Atom> &_atoms, Parameters &result_pars, DBInfo &info, bool sort=true)
                                      : result_pars(result_pars),
                                      atoms(sort ? query_sort(_atoms, {info, result_pars}) : _atoms),
                                      pars_per_atom(pars_per(atoms)),
                                      atom_per_pars(id_reverse(pars_per_atom)),
                                      par_amount(max_par(pars_per_atom)+1) {
#ifndef NDEBUG
        for (auto &atom : _atoms) {
            for (auto &arg : atom.get_args()) {
                assert(arg.is_variable());
            }
        }
#endif // TODO: important: since this is a thing now getting vars ia  lot easier, just remove duplicates

    }
};


struct JoinOrderElement {
    ll from_id;
    ll to_id;
    void* repr_ref; //TODO

    JoinOrderElement(ll i, ll j, void *repr_ref) : from_id(i), to_id(j), repr_ref(repr_ref) {}
    JoinOrderElement(ll i, ll j) : JoinOrderElement(i, j, nullptr) {}
};

struct AnnotatedJoinOrderElement {
    JoinOrderElement element;
    std::vector<ParRef> pars_joined; //TODO: shared ptr?, is copied during constr and afterwards
    std::vector<ParRef> pars_tracked; //TODO: shared ptr?, is copied during constr and afterwards
    //std::vector<ParRef> pars_result_tracked; //TODO: shared ptr?, is copied during constr and afterwards
};

typedef std::vector<JoinOrderElement> JoinOrder;
typedef std::vector<AnnotatedJoinOrderElement> AnnotatedJoinOrder;

}

}

#endif //HELP_CORE_JOIN_AND_PROJECT_H
