#ifndef FAST_BACKWARD_LEX_H
#define FAST_BACKWARD_LEX_H

//TODO: rename file to lex n parse or whatever, input handling maybe

#include <map>
#include <string>
#include <fstream>
#include "../input_handling/lexer/lexer.h"
#include "../input_handling/parser/datalog/datalog_parser.h"

namespace HELP {

auto lex_file(std::string &file_name, bool print=false) { //TODO: move this to lexer
    std::ifstream lex_file(file_name);
    cmd_error_if(!lex_file, "TODO file open failed"); //TODO

    Lexer::Lexer lexer(lex_file);
    lexer.lex();

    if (print) {
        lexer.dump_repr(std::cout); //TODO: allow to use file instead
    }

    return std::move(lexer.get_repr()); //TODO: does this make sense?
}

void lex_opt(std::map<std::string, std::string> &args) {
    cmd_error_if(!args.contains(DATALOG_FILE_FLAG), "Please provide a datalog or .pddl file as input. TODO: see ..."); //TODO: , not needed for ...;

    //TODO: probably should automatically detect flags somehow instead of always adding more bool parameters
    lex_file(args[DATALOG_FILE_FLAG], args.contains(LEX_PRINT_FLAG));
}

//TODO: important TODO important, this really gotta change (dict-like lookup instead 1000 pars)
auto parse_dl_file(std::string &file_name, bool print_lex=false, bool print_parse=false, bool print_stats=false, bool pred_print=false, bool join_order_print=false, bool annotated_join_order_print=false, bool join_order_graph_print=false, bool print_init_ground_actions=false, bool print_table_cache=false, bool combined_eval=false, bool add_print=false) { //TODO: move this to lexer
    auto lex_repr = lex_file(file_name, print_lex);

    //TODO: also support pddl
    DatalogParser parser(lex_repr);
    auto task = parser.parse_and_get_repr();

    if (print_parse) {
        task.dump_dl_repr(std::cout); //TODO: allow to use file instead
    }

    if (print_stats) {
        task.print_stats(std::cout); //TODO: allow to use file instead
    }

    if (pred_print) {
        task.print_predicates(std::cout);
    }

    task.normalize(); //TODO: only if needed?

    if (join_order_print) {
        task.print_normal_join_orders(std::cout);
    }

    if (annotated_join_order_print) {
        task.print_annotated_join_orders(std::cout);
    }

    if (join_order_graph_print) {
        task.print_join_order_graph(std::cout);
    }

    if (print_init_ground_actions) {
        task.print_initial_ground_actions(std::cout);
    }

    if (print_table_cache) {
        task.print_table_cache(std::cout);
    }

    if (combined_eval) {
        task.combined_query_eval_print(std::cout);
    }

    if (add_print) {
        task.print_initial_add_value(std::cout);
    }

    return task; //TODO: void
}

void parse_opt(std::map<std::string, std::string> &args) {
    //TODO: should fetch this from descr...
    cmd_error_if(!args.contains(DATALOG_FILE_FLAG), "Please provide a datalog or .pddl file as input. TODO: see ..."); //TODO: , not needed for ...;

    //TODO: probably should automatically detect flags somehow instead of always adding more bool parameters
    parse_dl_file(args[DATALOG_FILE_FLAG], args.contains(LEX_PRINT_FLAG), args.contains(PARSE_PRINT_FLAG), args.contains(STAT_FLAG), args.contains(PREDICATE_PRINT_FLAG), args.contains(JOIN_ORDER_FLAG), args.contains(ANNOTATED_JOIN_ORDER_FLAG), args.contains(JOIN_ORDER_GRAPH_FLAG), args.contains(INIT_GROUND_ACTIONS_FLAG), args.contains(TABLE_CACHE_FLAG), args.contains(COMBINED_EVAL_FLAG), args.contains(IHADD_FLAG));
}

}

#endif