#ifndef FAST_BACKWARD_CMD_OPT_H
#define FAST_BACKWARD_CMD_OPT_H

#include <string>
#include <set>
#include <map>
#include <vector>
#include <iostream>

//#include <ranges> TODO rm?
#include <string_view>
#include "../logging/logger.h"

//TODO: is adding

//TODO: maybe we wanna do some trickery with meta programming at some point and time
//TODO: if so: verify all have name, in release build there is no todo

//TODO: type declarations/renaming

#define to_flag(f) ("--" f) //TODO: should probably be a constexpr using views once clang supports that

namespace HELP {

constexpr auto LEX_FLAG = to_flag("lex");
constexpr auto PARSE_FLAG = to_flag("parse");

constexpr auto DATALOG_FILE_FLAG = "datalog_file";
constexpr auto LEX_PRINT_FLAG = "lex_print";
constexpr auto PARSE_PRINT_FLAG = "parse_print";
constexpr auto STAT_FLAG = "stat_print";
constexpr auto PREDICATE_PRINT_FLAG = "predicate_print";
constexpr auto JOIN_ORDER_FLAG = "join_order_print";
constexpr auto ANNOTATED_JOIN_ORDER_FLAG = "annotated_join_order_print";
constexpr auto JOIN_ORDER_GRAPH_FLAG = "join_order_graph_print";
constexpr auto INIT_GROUND_ACTIONS_FLAG = "init_ground_actions_print";
constexpr auto TABLE_CACHE_FLAG = "table_cache_print";
constexpr auto COMBINED_EVAL_FLAG = "combined_query_eval_print";
constexpr auto IHADD_FLAG = "inital_add_print";

struct Opt;

extern std::map<std::string, Opt> opt_storage;

inline void log_help() {
    Logger::log("TODO: print help");
}

inline void log_help_and_end() {
    log_help();
    Logger::error("Please enter a command line argument.");
}

inline void cmd_error_if(bool cond, std::string msg) {
    Logger::error_if(cond, {std::make_shared<TrivialStringBuilder>(msg)});
}

struct Opt {
    std::string descr;
    std::map<std::string, std::string> specification; //TODO: set opt_descr better?
    std::set<std::string> required;
    void (*_execute)(std::map<std::string, std::string> &args); //TODO: just use inheritance?

    void execute(std::map<std::string, std::string> &args) {
        (*_execute)(args);
    }
};

}


#endif