import os

# define the namespace
NAMESPACE = 'HELP'

# define the file extensions to wrap
FILE_EXTENSIONS = ['.h', '.hpp', '.cpp', '.tpp']

# get the current working directory
cwd = os.getcwd()

# loop through all the files in the directory and its subdirectories
for root, dirs, files in os.walk(cwd):
    for file in files:
        # get the file extension
        file_extension = os.path.splitext(file)[-1]
        if file_extension in FILE_EXTENSIONS:
            # construct the full path to the file
            file_path = os.path.join(root, file)

            # read the contents of the file
            with open(file_path, 'r') as f:
                file_contents = f.read()

            # split the file contents by lines
            lines = file_contents.split('\n')

            #TODO: skipping comments would have been useful

            # find the line number where the first #include statement occurs
            include_line_num = next((i for i, line in enumerate(lines) if not (line.strip().startswith('#include') or line.strip().startswith('using') or line.strip().startswith('#ifndef') or line.strip().startswith('#define') or len(line.strip())==0)), 0)

            # find the line number where the last #endif statement occurs
            endif_line_num = next((i+1 for i, line in reversed(list(enumerate(lines))) if not (line.strip().startswith('#include') or line.strip().startswith('#endif') or len(line.strip())==0)), len(lines))

            print(include_line_num, endif_line_num)

            # insert the ending } before the #endif statement
            lines.insert(endif_line_num, '\n}')

            # insert the namespace before the #include statements
            lines.insert(include_line_num, f'namespace {NAMESPACE} {{ \n')

            # join the lines back into a string
            wrapped_contents = '\n'.join(lines)

            # write the wrapped contents back to the file
            with open(file_path, 'w') as f:
                f.write(wrapped_contents)
