import os

# define the keywords to search for
NAMESPACE_KEYWORD = 'namespace'
INCLUDE_KEYWORD = '#include'

# get the current working directory
cwd = os.getcwd()

# loop through all the files in the directory and its subdirectories
for root, dirs, files in os.walk(cwd):
    for file in files:
        # construct the full path to the file
        file_path = os.path.join(root, file)

        # read the contents of the file
        with open(file_path, 'r') as f:
            file_contents = f.read()

        # find the index of the namespace keyword
        namespace_index = file_contents.find(NAMESPACE_KEYWORD)

        if namespace_index != -1:
            # find the index of the include keyword after the namespace keyword
            include_index = file_contents.find(INCLUDE_KEYWORD, namespace_index)

            if include_index != -1:
                # print the file path
                print(file_path)
