from machetli import pddl, search
import os

domain = "../../htg-domains/blocksworld-large-simple/goal-2/domain.pddl"
problem = "../../htg-domains/blocksworld-large-simple/goal-3/p-100-3.pddl"

CURRENT_DIR = "."
initial_state = pddl.generate_initial_state(domain, problem)
successor_generators = [pddl.RemoveActions(), pddl.RemoveObjects(), pddl.RemovePredicates(replace_with="true")]
evaluator_filename = os.path.join(CURRENT_DIR, "diverge_checker.py")

result = search(initial_state, successor_generators, evaluator_filename)

d = os.path.join(CURRENT_DIR, "reduced_domain.pddl")
p = os.path.join(CURRENT_DIR, "reduced_problem.pddl")
pddl.write_files(result, d, p)